<?php
/*------------------------------------------------------------------------
# fields.php - Ossolution Services Booking
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

class OSappscheduleFields{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static $_table = '#__oscalendar_fields';
	static $_table_option = '#__oscalendar_field_options';
	static $_scount = 'count(id)';
	static $_squery = '*';
	
	static function display($option,$task){
		global $app, $languages;
		$languages = self::getLanguages();
		if (JLanguageMultilang::isEnabled() && !self::isSyncronized())self::setupMultilingual();
		$app = JFactory::getApplication();
		$cid = $app->input->get( 'cid', array(0),'array');
		\Joomla\Utilities\ArrayHelper::toInteger($cid, array(0));	
		$document = JFactory::getDocument();
		$document->addScript(JURI::root()."components/com_osservicesbooking/js/ajax.js");
		
		switch ($task){
			default:
			case "fields_cancel":
				self::field_list($option);
			break;
			case "fields_publish":
				self::fields_state($option,$cid,1);
			break;	
			case "fields_unpublish":
				self::fields_state($option,$cid,0);
			break;	
			case "fields_remove":
				self::fields_remove($option,$cid);
			break;
			case "fields_saveorder":
				self::saveOrder($option);
			break;
			case "fields_orderdown":
				self::order($option,$cid[0],1);
			break;
			case "fields_orderup":
				self::order($option,$cid[0],-1);
			break;
			case "fields_edit":
				self::field_edit($option,$cid[0]);
			break;
			case "fields_add":
				self::field_edit($option,0);
			break;
			case "fields_apply":
				self::fields_save($option,0);
			break;
			case "fields_save":
				self::fields_save($option,1);
			break;
		}
	}

	
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $option
	 * @param unknown_type $save
	 */
	public static function fields_save($option,$save){
		global $app,$languages;
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		
		$translatable = JLanguageMultilang::isEnabled() && count($languages);
		
		$query = $db->getQuery(true);
		$post = $app->input->post->getArray();
		$row = &JTable::getInstance('Field','OsCalendarTable');
		$row->bind($post);
		if (!$row->id) $row->ordering = $row->getNextOrder();
		if ($row->field_type < 2) $row->field_free = 0;
		if($app->input->getString('field_free','off') == "on"){
			$row->field_free = 1;
		}else{
			$row->field_free = 0;
		}
		$row->store();
		$row->reorder();
		
		if($translatable){
			foreach ($languages as $language){	
				$sef = $language->sef;
				$field_label_language = $app->input->getString('field_label_'.$sef,'');
				if($field_label_language == ""){
					$field_label_language = $row->field_label;
				}
				if($field_label_language != ""){
					$field = &JTable::getInstance('Field','OsCalendarTable');
					$field->id = $row->id;
					$field->{'field_label_'.$sef} = $field_label_language;
					$field->store();
				}
			}
		}
		
		// remove old option
		$query	->clear()
				->delete(self::$_table_option)
				->where('field_id='.$row->id)
				;
		$db->setQuery($query);
		$db->execute();

		// add option
		$fieldoptions  = $app->input->get('fieldoption',array(),'array');
		$checkfieldoption = true;
		if(count($fieldoptions)){
			foreach ($fieldoptions as $fieldoption) {
				$item = &JTable::getInstance('FieldOption','OsCalendarTable');
				$item->bind($fieldoption);
				if(empty($item->field_option))continue;
				$item->field_id = $row->id;			
				$item->store();
				if($translatable){
					foreach ($languages as $language){	
						$sef = $language->sef;
						$field_option_language = $fieldoption['field_option_'.$sef];
						if($field_option_language == ""){
							$field_option_language = $item->field_option;
						}
						if($field_option_language != ""){
							$optionObj = &JTable::getInstance('FieldOption','OsCalendarTable');
							$optionObj->id = $item->id;
							$optionObj->{'field_option_'.$sef} = $field_option_language;
							$optionObj->store();
						}
					}
				}
				$checkfieldoption = false;
			}
		}
		
		// check create option
		if ($row->field_type > 1 && $checkfieldoption){
			$save = 0;
			$msg = JText::_('OS_THIS_FIELD_TYPE_OPTION_NOT_EMPTY_AND_OPTION_CREATED_WITH_CUSTOMFIELD_NOT_EMPTY');
		}else $msg = JText::_('OS_FIELD_HAS_BEEN_SAVED');
		
		$app->enqueueMessage($msg);	
		if($save) 	self::field_list($option);
		else 		self::field_edit($option,$row->id);
		return;
	}
	
	
	/**
	 * Field edit
	 *
	 * @param unknown_type $option
	 * @param unknown_type $id
	 */
	public static function field_edit($option,$id){
		global $app, $languages;
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$document = JFactory::getDocument();
		if (version_compare(JVERSION, '3.0', 'lt')) {
			$document = JFactory::getDocument();
			$document->addScript(JURI::root()."components/com_osproperty/js/bootstrap/js/jquery.min.js");
		}else{
			JHtml::_('jquery.framework');
		}
		
		$document->addScript(JURI::root()."administrator/components/com_oscalendar/asset/javascript/jscustomfield.js");
		$row = &JTable::getInstance('Field','OsCalendarTable');
		if($id > 0){
			$row->load((int)$id);
		}else{
			$row->published = 1;
		}
		// creat published
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option',1,JText::_('OS_YES'));
		$optionArr[] = JHTML::_('select.option',0,JText::_('OS_NO'));
		$lists['state']   = JHTML::_('select.genericlist',$optionArr,'published','class="input-mini form-control form-select"','value','text',$row->published);
		
		// creat field type
		$typeArr[] = JHTML::_('select.option','0',JText::_('OS_TEXTBOX'));
		$typeArr[] = JHTML::_('select.option','1',JText::_('OS_TEXTAREA'));
		$typeArr[] = JHTML::_('select.option','2',JText::_('OS_SELECTLIST'));
		$typeArr[] = JHTML::_('select.option','3',JText::_('OS_CHECKBOXES'));
		$lists['field_type'] = JHTML::_('select.genericlist',$typeArr,'field_type','class="inputbox  form-control form-select"','value','text',$row->field_type);
			
		// Build the query for the ordering list.
	 	$query	->clear()
	 			->select('ordering AS value')
	 			->select('field_label AS text')
	 			->from(self::$_table)
	 			->order('ordering')
	 			;
		$row->ordering = JHtml::_('list.ordering','ordering', $query,'class="inputbox  form-control form-select"', $row->ordering, !$row->id);
			
		// get option
		$lists['field_option'] = array();
		if ($row->id && $row->field_type >=2){
			$db = JFactory::getDbo();
			$query	->clear()
					->select('*')
					->from(self::$_table_option)
					->where('`field_id`='.$row->id)
					;
			$db->setQuery($query);
			$lists['field_option'] = $db->loadObjectList();
		}
		
		$translatable = JLanguageMultilang::isEnabled() && count($languages);

		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','0',JText::_('OSC_FOR_ORDER'));
		$optionArr[] = JHTML::_('select.option','1',JText::_('OSC_FOR_EACH_ROOM_OF_ORDER'));
		$lists['price_for_order'] = JHTML::_('select.genericlist',$optionArr,'price_for_order','class="input-medium form-control form-select"','value','text',$row->price_for_order);
	
		HTML_OSappscheduleFields::field_edit($option,$row,$lists,$translatable);
	}
	
	/**
	 * Get front-end default language
	 * @return string
	 */
	public static function getDefaultLanguage()
	{
		$params = JComponentHelper::getParams('com_languages');
		return $params->get('site', 'en-GB');
	}
	
	/**
	 * Enter description here...
	 *
	 * @return unknown
	 */
	public static function getLanguages()
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$default = self::getDefaultLanguage();
		$query->select('lang_id, lang_code, title, `sef`')
			->from('#__languages')
			->where('published = 1')
			->where('lang_code != "' . $default . '"')
			->order('ordering');
		$db->setQuery($query);
		$languages = $db->loadObjectList();
		$java = 'var languages = new Array();'."\n";
		foreach ($languages AS $language) {
			$java .= 'languages.push({value:'.$db->quote($language->sef).', text: '.$db->quote('&nbsp;'.JHtml::_('image', 'mod_languages/'.$language->sef.'.gif', $language->sef, array('title' => $language->sef), true)).'});'."\n";
		}
		$document = JFactory::getDocument();
		$document->addScriptDeclaration($java);
		return $languages;
	}
	
	/**
	 * Syncronize Extra fields database to support multilingual
	 */
	public static function setupMultilingual(){
		global $languages;
		$db = JFactory::getDbo();
		$fields = array_keys($db->getTableColumns(self::$_table));
		$fieldoptions = array_keys($db->getTableColumns(self::$_table_option));
		if (count($languages)){
			foreach ($languages as $language){
				$prefix = $language->sef;
				if (!in_array('field_label_' . $prefix, $fields)){
					$fieldName = 'field_label_' . $prefix;
					$sql = "ALTER TABLE  `".self::$_table."` ADD  `$fieldName` VARCHAR( 255 ) NULL DEFAULT NULL;";
					$db->setQuery($sql);
					$db->execute();
				}
				if (!in_array('field_option_' . $prefix, $fieldoptions)){
					$fieldName = 'field_option_' . $prefix;
					$sql = "ALTER TABLE  `".self::$_table_option."` ADD  `$fieldName` VARCHAR( 255 ) NULL DEFAULT NULL;";
					$db->setQuery($sql);
					$db->execute();
				}
			}
		}
	}
	/**
	 * Enter description here...
	 *
	 * @return unknown
	 */
	public static function isSyncronized(){
		global $languages;
		$db = JFactory::getDbo();
		$fields = array_keys($db->getTableColumns(self::$_table));
		$fieldoptions = array_keys($db->getTableColumns(self::$_table_option));
		if (count($languages)){
			foreach ($languages as $extraLanguage){
				$prefix = $extraLanguage->sef;
				if (!in_array('field_label_' . $prefix, $fields) || !in_array('field_option_' . $prefix, $fieldoptions))return false;
			}
		}
		
		return true;
	}
	/**
	 * Order Item
	 *
	 * @param unknown_type $item
	 * @param unknown_type $movement
	 * @return unknown
	 */
	public static function order($option,$id, $movement){
		global $app;
		$app 	= JFactory::getApplication();
		$row = &JTable::getInstance('Field','OsCalendarTable');
		if (!$id){
			$app->enqueueMessage(JText::_('OS_NO_ITEM_SELECTED'),'message');
			self::field_list($option);
			return;
		}else $row->load( $id );
		$movement = (Jrequest::getVar('filter_order_Dir')=='asc')? $movement:(-1).$movement;
		if (!$row->move( $movement)) {
			$app->enqueueMessage($row->getError(),'message');
			self::field_list($option);
			return;
		}
		$row->reorder();
		$app->enqueueMessage(JText::_( 'OS_ONE_ITEM_MOVED' ),'message');
		self::field_list($option);
		return;
	}
	
	/**
	 * Save order
	 *
	 * @param unknown_type $option
	 */
	public static function saveorder($option){
		global $app;
		$app 	= JFactory::getApplication();
		$db = JFactory::getDBO();
		$cid 	= $app->input->get( 'cid', array(),  'array' );
		$order 	= $app->input->get( 'order', array(), 'array' );
		\Joomla\Utilities\ArrayHelper::toInteger($cid);
		\Joomla\Utilities\ArrayHelper::toInteger($order);
		$row = &JTable::getInstance('Field','OsCalendarTable');
		// update ordering values
		for( $i=0; $i < count($cid); $i++ ){
			$row->load( (int) $cid[$i] );
			if ($row->ordering != $order[$i]){
				$row->ordering = $order[$i];
				if (!$row->store()) {
					$app->enqueueMessage($db->getErrorMsg(),'message');
					self::field_list($option);
					return;
				}
			}
		}
		$row->reorder();
		$app->enqueueMessage(JText::_( 'OS_NEW_ORDERING_SAVED' ),'message');
		self::field_list($option);
		return;
	}
	/**
	 * publish or unpublish agent
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 * @param unknown_type $state
	 */
	public static function fields_state($option,$cid,$state){
		global $app;
		$app 	= JFactory::getApplication();
		$db 	= JFactory::getDbo();
		if(count($cid)>0)	{
			$cids 	= implode(",",$cid);
			$query = $db->getQuery(true);
			$query	->clear()
					->update(self::$_table)
					->set("`published` = '$state'")
					->where("id IN ($cids)")
					;
			$db->setQuery($query);
			$db->execute();
		}
		$app->enqueueMessage(JText::_("OS_ITEMS_STATUS_HAS_BEEN_CHANGED"),'message');
		self::field_list($option);
		return;
	}
	
	/**
	 * remove agent
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 */
	public static function fields_remove($option,$cid){
		global $app;
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		if(count($cid)>0)	{
			$cids = implode(",",$cid);
			$query = $db->getQuery(true);
			$query	->clear()
					->delete(self::$_table)
					->where("id IN ($cids)")
					;
			$db->setQuery($query);
			$db->execute();
			
			$query	->clear()
					->delete(self::$_table_option)
					->where("field_id IN ($cids)")
					;
			$db->setQuery($query);
			$db->execute();
			
		}
		$app->enqueueMessage(JText::_("OS_CALENDAR_ITEM_HAS_BEEN_DELETED"),'message');
		self::field_list($option);
		return;
	}
	
	
	/**
	 * Field list
	 *
	 * @param unknown_type $option
	 */
	public static function field_list($option){
		global $app;
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		$lists = array();
		$lists[0] = JText::_('OS_TEXTBOX');
		$lists[1] = JText::_('OS_TEXTAREA');
		$lists[2] = JText::_('OS_SELECTLIST');
		$lists[3] = JText::_('OS_CHECKBOXES');
		$filter_order 				= $app->input->getString('filter_order','ordering');
		$filter_order_Dir 			= $app->input->getString('filter_order_Dir','asc');
		$lists['order'] 			= $filter_order;
		$lists['order_Dir'] 		= $filter_order_Dir;
		$order_by 					= "$filter_order $filter_order_Dir";
		$limit						= $app->input->getInt('limit',20);
		$limitstart					= $app->input->getInt('limitstart',0);
		
		// count record
			$query = $db->getQuery(true);
			$query	->clear()
					->select(self::$_scount)
					->from(self::$_table)
					;
			$db->setQuery($query);
			$total = $db->loadResult();
			jimport('joomla.html.pagination');
			$pageNav = new JPagination($total,$limitstart,$limit);
		
		// get record
			$query = $db->getQuery(true);
			$query	->clear()
					->select(self::$_squery)
					->from(self::$_table)
					->order($order_by);
					;
			$db->setQuery($query,$pageNav->limitstart,$pageNav->limit);
			$rows = $db->loadObjectList();
		
		HTML_OsAppscheduleFields::listFields($option,$rows,$pageNav,$lists);
	}
}
?>