<?php
/*------------------------------------------------------------------------
# cpanel.php - Ossolution Services Booking
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

class OSappscheduleCpanel{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		switch ($task){
			case "cpanel_optimizedatabase":
				//OSappscheduleCpanel::optimizeDatabase();
			break;
			case "cpanel_sefoptimize":
				OSappscheduleCpanel::sefOptimization($option);
			break;
			case "cpanel_list":
			default:
				OSappscheduleCpanel::cpanel_list($option);
			break;
		}
	}
	
	static function sefOptimization($option){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("Delete from #__oscalendar_urls");
		$db->execute();
		$mainframe->enqueueMessage(JText::_('OS_SEF_URLS_HAVE_BEEN_OPTIMIZED'));
		$mainframe->redirect("index.php?option=com_oscalendar&task=cpanel_list");
	}
	
	/**
	 * Control panel
	 *
	 * @param unknown_type $option
	 */
	static function cpanel_list($option){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$report_type = $mainframe->input->getInt('report_type',0);
		// set the Options
		$options = array();
		if($report_type == 0){
			$report_year = $mainframe->input->getInt('report_year',date("Y",time()));
			$temp = array();
			$j = 0;
			for($i=1;$i<=12;$i++){
				$m = $i + 1;
				if($m<10){
					$month = "0".$m;
				}else{
					$month = $m;
				}
				$db->setQuery("Select SUM(total_amount) from #__oscalendar_booking where order_date like '".$report_year."-".$month."%' and order_status = 'P'");
				$temp[$j] = new StdClass();
				$temp[$j]->pending = intval($db->loadResult());
				$db->setQuery("Select SUM(total_amount) from #__oscalendar_booking where order_date like '".$report_year."-".$month."%' and order_status = 'S'");
				$temp[$j]->complete = intval($db->loadResult());
				$j++;
			}
			$chart_title = JText::_('OS_INCOME_REPORT')." ".$report_year;
			$chart_data = "[['".JText::_('OS_MONTH')."', '".JText::_('OS_PENDING')."' ,'".JText::_('OS_COMPLETE')."'],";
			for($i=0;$i<count($temp);$i++){
				$t = $temp[$i];
				$m = $i + 1;
				if($m<10){
					$month = "0".$m;
				}else{
					$month = $m;
				}
				$chart_data .= "['".$month."',".$temp[$i]->pending.",".$temp[$i]->complete."],";
			}
			$chart_data = substr($chart_data,0,strlen($chart_data)-1);
			$chart_data .= "]";
		}else{
			$year_from = $mainframe->input->getInt('year_from',0);
			$year_to   = $mainframe->input->getInt('year_to',0);
			
			if($year_to > $year_from){
				$temp = array();
				$j = 0;
				for($i=$year_from;$i<=$year_to;$i++){
					$temp[$j]->year = $i;
					$db->setQuery("Select SUM(total) from #__oscalendar_booking where order_date >= '".$i."-01-01' and order_date <= '".$i."-12-31' and order_status = 'P'");
					$temp[$j]->pending = intval($db->loadResult());
					$db->setQuery("Select SUM(total) from #__oscalendar_booking where order_date >= '".$i."-01-01' and order_date <= '".$i."-12-31' and order_status = 'S'");
					$temp[$j]->complete = intval($db->loadResult());
					$j++;
				}
				$chart_data = "[['".JText::_('OS_YEAR')."', '".JText::_('OS_PENDING')."' ,'".JText::_('OS_COMPLETE')."'],";
				for($i=0;$i<count($temp);$i++){
					$t = $temp[$i];
					$chart_data .= "['".$temp[$i]->year."',".$temp[$i]->pending.",".$temp[$i]->complete."],";
				}
				$chart_data = substr($chart_data,0,strlen($chart_data)-1);
				$chart_data .= "]";
			}
			$chart_title = JText::_('OS_INCOME_REPORT_FROM')." ".$year_from." ".JText::_('OS_TO')." ".$year_to;
		}
		
		$chart_galllery = "BarChart";
		
		$lists['chart'] = $chart_data;
		$lists['title'] = $chart_title;
		$lists['report_type']= $report_type;
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option',0,JText::_('OS_REPORT_BY_YEAR'));
		$optionArr[] = JHTML::_('select.option',1,JText::_('OS_REPORT_BY_YEAR_RANGE'));
		$lists['report_type'] = JHTML::_('select.genericlist',$optionArr,'report_type','onChange="javascript:loadDiv()"','value','text',$report_type);
		
		$optionArr = array();
		$current_year = date("Y",time());
		for($i=$current_year;$i>=$current_year-5;$i--){
			$optionArr[] = JHTML::_('select.option',$i,$i);
		}
		$lists['report_year'] = JHTML::_('select.genericlist',$optionArr,'report_year','','value','text',$report_year);
		
		$optionArr = array();
		$current_year = date("Y",time());
		for($i=$current_year;$i>=$current_year-5;$i--){
			$optionArr[] = JHTML::_('select.option',$i,$i);
		}
		$lists['year_from'] = JHTML::_('select.genericlist',$optionArr,'year_from','','value','text',$year_from);
		$lists['year_to'] = JHTML::_('select.genericlist',$optionArr,'year_to','','value','text',$year_to);
		
		HTML_OSappscheduleCpanel::showControlpanel($lists);
	}
	
	/**
	 * Creates the buttons view.
	 * @param string $link targeturl
	 * @param string $image path to image
	 * @param string $text image description
	 * @param boolean $modal 1 for loading in modal
	 */
	static function quickiconButton($link, $image, $text, $modal = 0)
	{
		//initialise variables
		$lang 		= &JFactory::getLanguage();
  		?>

		<div style="float:<?php echo ($lang->isRTL()) ? 'right' : 'left'; ?>;">
			<div class="icon">
				<?php
				if ($modal == 1) {
					JHTML::_('behavior.modal');
				?>
					<a href="<?php echo $link.'&amp;tmpl=component'; ?>" style="cursor:pointer" class="modal" rel="{handler: 'iframe', size: {x: 650, y: 400}}">
				<?php
				} else {
				?>
					<a href="<?php echo $link; ?>">
				<?php
				}
					echo JHTML::_('image', 'administrator/components/com_oscalendar/asset/images/' . $image, $text);
				?>
					<span><?php echo $text; ?></span>
				</a>
			</div>
		</div>
		<?php
	}
}
?>