<?php
// namespace administrator\components\com_jmap\plugins;
/**
 * @package JMAP::EXTERNALPLUGINS::administrator::components::com_jmap
 * @subpackage plugins
 * @author Joomla! Extensions Store
 * @copyright (C) 2015 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

/**
 * External plugin data source
 * It's the concrete implementation of the interface JMapFilePlugin
 * that retrieves data in an arbitrary way or resource and returns them
 * following a specific format to render the sitemap in every format supported HTML, XML, etc
 *
 * @package JMAP::FRAMEWORK::components::com_jmap
 * @subpackage plugins
 * @since 3.3
 */
class JMapFilePluginOSProperty implements JMapFilePlugin {
	/**
	 * Retrieves records for the plugin data source using whatever way and resource is required
	 * Formats and returns an associative array of data based on the following scheme  
	 *
	 * @param JRegistry The object holding configuration parameters for the plugin and data source
	 * @param JDatabase $db The database connector object
	 * @param JMapModel $sitemapModel The sitemap model object reference, it's needed to manage limitStart, limitRows properties and affected_rows state
	 *        	
	 * @return array
	 * This function must return an associative array as following:
	 * $returndata['items'] -> It's the mandatory objects array of elements, it must contain at least title and routed link fields
	 * $returndata['items_tree'] -> Needed to render elements grouped by cats with a nested tree, not mandatory
	 * $returndata['categories_tree'] -> Needed to render elements grouped by cats with a nested tree, not mandatory
	 * 
	 * $returndata['items'] must contain records objects with following properties (* = required)
	 * 						->title * A string for the title
	 * 						->link * A string for the link
	 * 						->lastmod (used for XML sitemap) A date string in MySql format yyyy-mm-dd hh:ii:ss
	 * 						->metakey (used for Google news sitemap) A string for metakeys of each record
	 * 						->publish_up (used for Google news sitemap) A date string in MySql format yyyy-mm-dd hh:ii:ss
	 * 						->access (used for Google news sitemap, >1 = registration access) An integer for Joomla! access level of each record
	 * 
	 * $returndata['items_tree'] must be a numerical array that groups items by the containing category id, the index of the array is the category id 
	 * 
	 * $returndata['categories_tree'] must be a numerical array that groups categories by parent category, the index of the array is the category parent id,
	 * 								  the elements of the array must be records objects representing categories with following properties (* = required)
	 * 						->category_id * An integer for the category ID
	 * 						->category_title * A string for the category title
	 * 						->category_link * A string for the category link
	 * 						->lastmod (used for XML sitemap) A date string in MySql format yyyy-mm-dd hh:ii:ss
	 */
	public function getSourceData(JRegistry $pluginParams, JDatabase $db, JMapModel $sitemapModel) {
		// Check if the extension is installed
		if(!file_exists(JPATH_SITE . '/components/com_osproperty')) {
			throw new JMapException(JText::sprintf('COM_JMAP_ERROR_EXTENSION_NOTINSTALLED', 'OS Property'), 'warning');
		}

		$filter_type = $pluginParams->get('filter_type',0);
		
		$hasMultilanguageSupport = $pluginParams->get('multilanguage_support', 0);
		$isMultilanguage = JMapLanguageMultilang::isEnabled();
		$sefLanguage = JMapLanguageMultilang::getCurrentSefLanguage();
		
		// The associative array holding the returned data
		$returndata = array();
		$multilangProperty = null;
		
		if($hasMultilanguageSupport && $isMultilanguage) {
			$propertiesFieldsQuery = "SHOW COLUMNS FROM `#__osrs_properties`";
			$db->setQuery($propertiesFieldsQuery);
			$propertiesFields = $db->loadColumn();
			if(method_exists($db, 'getErrorNum')) {
				if ($db->getErrorNum ()) {
					throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
				}
			}
			if(in_array("pro_name_$sefLanguage", $propertiesFields)) {
				$multilangProperty = "\n `#__osrs_properties`.`pro_name_$sefLanguage` AS `multilang_title`,";
			}
		}
		
		// Categories
		if($filter_type == 0){
			$itemsQuery = "SELECT" .
						  "\n `#__osrs_properties`.`pro_name` AS `title`," .
						  $multilangProperty .
						  "\n `#__osrs_properties`.`id` AS `item_id`," .
						  "\n `#__osrs_property_categories`.`category_id` AS `catid`," .
						  "\n `#__osrs_properties`.`modified` AS " . $db->quoteName('lastmod') . "," .
						  "\n `#__osrs_properties`.`created`," .
						  "\n `#__osrs_categories`.`id` AS " . $db->quoteName('jsitemap_category_id') . "," .
						  "\n `#__osrs_categories`.`category_name` AS " . $db->quoteName('catname') .
						  "\n FROM `#__osrs_properties`" .
						  "\n LEFT JOIN `#__osrs_property_categories` ON `#__osrs_properties`.`id` = `#__osrs_property_categories`.`pid`" .
						  "\n JOIN `#__osrs_categories` ON `#__osrs_categories`.`id` = `#__osrs_property_categories`.`category_id`" .
						  "\n WHERE" .
						  "\n `#__osrs_properties`.`published` = 1" .
						  "\n ORDER BY" .
						  "\n `#__osrs_categories`.`category_name`," .
						  "\n `#__osrs_properties`.`pro_name` ASC";
			// Check if a limit for query rows has been set, this means we are in precaching process by JS App client
			if(!$sitemapModel->limitRows) {
				$items = $db->setQuery($itemsQuery)->loadObjectList();
			} else {
				$items = $db->setQuery($itemsQuery, $sitemapModel->limitStart, $sitemapModel->limitRows)->loadObjectList();
			}

			if(method_exists($db, 'getErrorNum')) {
				if ($db->getErrorNum ()) {
					throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
				}
			}

			// Detected a precaching call, we have to store in the model state the number of affected rows for the JS application
			if($sitemapModel->limitRows) {
				$sitemapModel->setState('affected_rows', count($items));
			}
			
			// Minimum route helper
			$guessedItemid = null;
			$itemidQuery = "SELECT" .
						   "\n menu.id" .
						   "\n FROM #__menu AS " . $db->quoteName('menu') .
						   "\n WHERE" .
						   "\n menu.link = " . $db->quote('index.php?option=com_osproperty&view=lcategory') .
						   "\n AND menu.published = 1" .
						   "\n AND menu.client_id = 0";
			$guessedItemid = $db->setQuery($itemidQuery)->loadResult();
			// Fallback on submit form link
			if(!$guessedItemid) {
				$itemidQuery = "SELECT" .
							   "\n menu.id" .
							   "\n FROM #__menu AS " . $db->quoteName('menu') .
							   "\n WHERE" .
							   "\n menu.link LIKE " . $db->quote('%index.php?option=com_osproperty&view=aaddproperty%') .
							   "\n AND menu.published = 1" .
							   "\n AND menu.client_id = 0";
				$guessedItemid = $db->setQuery($itemidQuery)->loadResult();
			}
			// Fallback on generic link
			if(!$guessedItemid) {
				$itemidQuery = "SELECT" .
							   "\n menu.id" .
							   "\n FROM #__menu AS " . $db->quoteName('menu') .
							   "\n WHERE" .
							   "\n menu.link LIKE " . $db->quote('%index.php?option=com_osproperty%') .
							   "\n AND menu.published = 1" .
							   "\n AND menu.client_id = 0";
				$guessedItemid = $db->setQuery($itemidQuery)->loadResult();
			}
			
			// Route links for each record
			require_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
			require_once(JPATH_ROOT.'/components/com_osproperty/helpers/route.php');

			if(count($items)) {
				$itemsByCats = array();
				$multilanguageEnabled = $hasMultilanguageSupport && $isMultilanguage;
				foreach ($items as $item) {
					$needs = array();
					$needs[] = "property_details";
					$needs[] = $item->item_id;
					$itemid  = OSPRoute::getItemid($needs);
					if(!$itemid && $guessedItemid) {
						$itemid = $guessedItemid;
					}
					$item->link = JRoute::_('index.php?option=com_osproperty&task=property_details&id=' . $item->item_id. '&Itemid='.$itemid);
					// Check if a valid last modified date is available for this record, fallback on the publish date
					if(!$item->lastmod || in_array($item->lastmod, array('0000-00-00 00:00:00', '1000-01-01 00:00:00'))) {
						$item->lastmod = $item->created;
					}
					
					// Check for multilanguage and swap titles
					if($multilanguageEnabled) {
						if(isset($item->multilang_title)) {
							$item->title = $item->multilang_title;
						}
					}
					
					// First pass organize items by containing cats
					$itemsByCats[$item->catid][] = $item;
				}
				$returndata['items'] = $items; // Assign items
				$returndata['items_tree'] = $itemsByCats; // Assign items grouped by category
			}
			
			// Build the categories tree
			$multilangCategory = null;
			if($hasMultilanguageSupport && $isMultilanguage) {
				$categoriesFieldsQuery = "SHOW COLUMNS FROM `#__osrs_categories`";
				$db->setQuery($categoriesFieldsQuery);
				$categoriesFields = $db->loadColumn();
				if(method_exists($db, 'getErrorNum')) {
					if ($db->getErrorNum ()) {
						throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
					}
				}
				if(in_array("category_name_$sefLanguage", $categoriesFields)) {
					$multilangCategory = "\n `#__osrs_categories`.`category_name_$sefLanguage` AS `multilang_category_title`,";
				}
			}
			
			$catsQuery = "SELECT DISTINCT" . 
						 "\n #__osrs_categories.id AS " . $db->quoteName('category_id') . "," .
						 $multilangCategory .
						 "\n #__osrs_categories.category_name AS " . $db->quoteName('category_title') .
						 "\n FROM " . $db->quoteName('#__osrs_categories') .
						 "\n WHERE #__osrs_categories.published = 1" ;
			$totalItemsCats = $db->setQuery($catsQuery)->loadObjectList();
			if(method_exists($db, 'getErrorNum')) {
				if ($db->getErrorNum ()) {
					throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
				}
			}
			 
			$catsTreeQuery = "SELECT" .
							 "\n #__osrs_categories.parent_id AS " . $db->quoteName('parent') . "," .
							 "\n #__osrs_categories.id AS " . $db->quoteName('child') .
							 "\n FROM " .$db->quoteName('#__osrs_categories');
			$totalItemsCatsTree = $db->setQuery($catsTreeQuery)->loadAssocList('child');
			if(method_exists($db, 'getErrorNum')) {
				if ($db->getErrorNum ()) {
					throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
				}
			}

			// Second pass organize the categories tree by parent -> children
			$catsTree = array();
			if(count($totalItemsCats)) {
				// Check if categories must be linkable
				$linkableCats = $pluginParams->get('linkable_content_cats', 1);
				foreach ($totalItemsCats as &$childCat) {
					// Check for multilanguage and swap titles
					if($multilanguageEnabled) {
						if(isset($childCat->multilang_category_title)) {
							$childCat->category_title = $childCat->multilang_category_title;
						}
					}
					
					if($linkableCats) {
						$childCat->category_alias = JFilterOutput::stringURLSafe($childCat->category_title);
						$childCat->category_link = JRoute::_ ('index.php?option=com_osproperty&task=category_details&id=' . $childCat->category_id . '&Itemid='.$itemid);
					}
					
					$parentCat = $totalItemsCatsTree[$childCat->category_id]['parent'];
					$catsTree[$parentCat][] = $childCat;
				}
			}
			$returndata['categories_tree'] = $catsTree; // Assign the categories tree
		}
		else //property type
		{
			$itemsQuery = "SELECT" .
						  "\n `#__osrs_properties`.`pro_name` AS `title`," .
						  $multilangProperty .
						  "\n `#__osrs_properties`.`id` AS `item_id`," .
						  "\n `#__osrs_properties`.`modified` AS " . $db->quoteName('lastmod') . "," .
						  "\n `#__osrs_properties`.`created`," .
						  "\n `#__osrs_types`.`id` AS " . $db->quoteName('jsitemap_category_id') . "," .
						  "\n `#__osrs_types`.`type_name` AS " . $db->quoteName('catname') .
						  "\n FROM `#__osrs_properties`" .
						  "\n JOIN `#__osrs_types` ON `#__osrs_types`.`id` = `#__osrs_properties`.`pro_type`" .
						  "\n WHERE" .
						  "\n `#__osrs_properties`.`published` = 1" .
						  "\n ORDER BY" .
						  "\n `#__osrs_types`.`type_name`," .
						  "\n `#__osrs_properties`.`pro_name` ASC";
			// Check if a limit for query rows has been set, this means we are in precaching process by JS App client
			if(!$sitemapModel->limitRows) {
				$items = $db->setQuery($itemsQuery)->loadObjectList();
			} else {
				$items = $db->setQuery($itemsQuery, $sitemapModel->limitStart, $sitemapModel->limitRows)->loadObjectList();
			}

			if(method_exists($db, 'getErrorNum')) {
				if ($db->getErrorNum ()) {
					throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
				}
			}

			// Detected a precaching call, we have to store in the model state the number of affected rows for the JS application
			if($sitemapModel->limitRows) {
				$sitemapModel->setState('affected_rows', count($items));
			}
			
			// Minimum route helper
			$guessedItemid = null;
			$itemidQuery = "SELECT" .
						   "\n menu.id" .
						   "\n FROM #__menu AS " . $db->quoteName('menu') .
						   "\n WHERE" .
						   "\n menu.link = " . $db->quote('index.php?option=com_osproperty&view=lcategory') .
						   "\n AND menu.published = 1" .
						   "\n AND menu.client_id = 0";
			$guessedItemid = $db->setQuery($itemidQuery)->loadResult();
			// Fallback on submit form link
			if(!$guessedItemid) {
				$itemidQuery = "SELECT" .
							   "\n menu.id" .
							   "\n FROM #__menu AS " . $db->quoteName('menu') .
							   "\n WHERE" .
							   "\n menu.link LIKE " . $db->quote('%index.php?option=com_osproperty&view=aaddproperty%') .
							   "\n AND menu.published = 1" .
							   "\n AND menu.client_id = 0";
				$guessedItemid = $db->setQuery($itemidQuery)->loadResult();
			}
			// Fallback on generic link
			if(!$guessedItemid) {
				$itemidQuery = "SELECT" .
							   "\n menu.id" .
							   "\n FROM #__menu AS " . $db->quoteName('menu') .
							   "\n WHERE" .
							   "\n menu.link LIKE " . $db->quote('%index.php?option=com_osproperty%') .
							   "\n AND menu.published = 1" .
							   "\n AND menu.client_id = 0";
				$guessedItemid = $db->setQuery($itemidQuery)->loadResult();
			}
			
			// Route links for each record
			require_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
			require_once(JPATH_ROOT.'/components/com_osproperty/helpers/route.php');

			if(count($items)) {
				$itemsByCats = array();
				$multilanguageEnabled = $hasMultilanguageSupport && $isMultilanguage;
				
				foreach ($items as $item) {
					$needs = array();
					$needs[] = "property_details";
					$needs[] = $item->item_id;
					$itemid  = OSPRoute::getItemid($needs);
					if(!$itemid && $guessedItemid) {
						$itemid = $guessedItemid;
					}
					$item->link = JRoute::_('index.php?option=com_osproperty&task=property_details&id=' . $item->item_id. '&Itemid='.$itemid);
					// Check if a valid last modified date is available for this record, fallback on the publish date
					if(!$item->lastmod || in_array($item->lastmod, array('0000-00-00 00:00:00', '1000-01-01 00:00:00'))) {
						$item->lastmod = $item->created;
					}
					
					// Check for multilanguage and swap titles
					if($multilanguageEnabled) {
						if(isset($item->multilang_title)) {
							$item->title = $item->multilang_title;
						}
					}
					
					// First pass organize items by containing cats
					$itemsByCats[$item->jsitemap_category_id][] = $item;
				}
				$returndata['items'] = $items; // Assign items
				$returndata['items_tree'] = $itemsByCats; // Assign items grouped by category
			}
			
			
			$multilangTypes = null;
			if($hasMultilanguageSupport && $isMultilanguage) {
				$typesFieldsQuery = "SHOW COLUMNS FROM `#__osrs_types`";
				$db->setQuery($typesFieldsQuery);
				$typesFields = $db->loadColumn();
				if(method_exists($db, 'getErrorNum')) {
					if ($db->getErrorNum ()) {
						throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
					}
				}
				if(in_array("type_name_$sefLanguage", $typesFields)) {
					$multilangTypes = "\n `#__osrs_types`.`type_name_$sefLanguage` AS `multilang_category_title`,";
				}
			}
			
			// Build the categories tree
			$catsQuery = "SELECT DISTINCT" . 
						 "\n #__osrs_types.id AS " . $db->quoteName('category_id') . "," .
						 $multilangTypes .
						 "\n #__osrs_types.type_name AS " . $db->quoteName('category_title') .
						 "\n FROM " . $db->quoteName('#__osrs_types') .
						 "\n WHERE #__osrs_types.published = 1" ;
			$totalItemsCats = $db->setQuery($catsQuery)->loadObjectList();
			if(method_exists($db, 'getErrorNum')) {
				if ($db->getErrorNum ()) {
					throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
				}
			}
			 
			$catsTreeQuery = "SELECT" .
							 "\n #__osrs_types.id AS " . $db->quoteName('child') .
							 "\n FROM " .$db->quoteName('#__osrs_types');
			$totalItemsCatsTree = $db->setQuery($catsTreeQuery)->loadAssocList('child');
			if(method_exists($db, 'getErrorNum')) {
				if ($db->getErrorNum ()) {
					throw new JMapException(JText::sprintf('COM_JMAP_ERROR_RETRIEVING_DATA_FROM_PLUGIN_DATASOURCE', $db->getErrorMsg()), 'warning');
				}
			}

			// Second pass organize the categories tree by parent -> children
			$catsTree = array();
			if(count($totalItemsCats)) {
				// Check if categories must be linkable
				$linkableCats = $pluginParams->get('linkable_content_cats', 1);
				foreach ($totalItemsCats as &$childCat) {
					// Check for multilanguage and swap titles
					if($multilanguageEnabled) {
						if(isset($childCat->multilang_category_title)) {
							$childCat->category_title = $childCat->multilang_category_title;
						}
					}
					
					if($linkableCats) {
						$childCat->category_alias = JFilterOutput::stringURLSafe($childCat->category_title);
						$childCat->category_link = JRoute::_ ('index.php?option=com_osproperty&task=property_type&id=' . $childCat->category_id . '&Itemid='.$itemid);
					}
					
					$parentCat = $totalItemsCatsTree[$childCat->category_id]['parent'];
					$catsTree[0][] = $childCat;
				}
			}
			$returndata['categories_tree'] = $catsTree; // Assign the categories tree
		}
		
		return $returndata;
	}
}