<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/core
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2023 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace CodeAlfa\Component\JchOptimize\Administrator\Extension;

use CodeAlfa\Component\JchOptimize\Administrator\Service\Html\DashIcons;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Psr\Container\ContainerInterface;

use function defined;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die('Restricted Access');
// phpcs:enable PSR1.Files.SideEffects

class JchOptimizeComponent extends MVCComponent implements BootableExtensionInterface, ContainerServiceInterface
{
    use HTMLRegistryAwareTrait;
    use ContainerServiceTrait;

    public function boot(ContainerInterface $container): void
    {
        $this->getRegistry()->register('dashicons', new DashIcons());
    }
}
