<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads.
 *
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2023 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace JchOptimize\Core\Admin;

class EventStream
{
    private string $event;
    private string $data;

    public function __construct($data, $event = '')
    {
        $this->event = $event;
        $this->data = $data;
    }

    public function __toString()
    {
        $stream = '';
        if ($this->event) {
            $stream .= "event: {$this->event}\n";
        }
        $stream .= "data: {$this->data}";
        $stream .= \str_pad('', 4096, "\n");

        return $stream;
    }

    public static function send($data, $event = '')
    {
        $eventStream = new \JchOptimize\Core\Admin\EventStream($data, $event);
        echo $eventStream;
        \ob_flush();
    }
}
