<?php
/**
 * Form Field class for the Joomla HDP.
 * Supports a radio list custom field.
 *
 * @package     Joomla.HDP
 * @subpackage  Form
 */

use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

class HDPFormFieldRadio extends HDPFormField
{

	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 */
	protected $type = 'Radio';

	/**
	 * Options for Radiolist
	 * @var array
	 */
	protected $options = [];

	/**
	 * Number options displayed perrow
	 * @var int
	 */
	protected $optionsPerRow = 1;

	/**
	 * Method to instantiate the form field object.
	 *
	 * @param JTable $row   the table object store form field definitions
	 * @param mixed  $value the initial value of the form field
	 *
	 */
	public function __construct($row, $value)
	{
		parent::__construct($row, $value);

		if ((int) $row->size)
		{
			$this->optionsPerRow = (int) $row->size;
		}

		if (is_array($row->values))
		{
			$this->options = $row->values;
		}
		elseif (strpos($row->values, "\r\n") !== false)
		{
			$this->options = explode("\r\n", $row->values);
		}
		else
		{
			$this->options = explode(',', $row->values);
		}

		$this->options = array_map('trim', $this->options);
	}

	/**
	 * Method to get the field input markup.
	 *
	 * @param HelpdeskProHelperBootstrap $bootstrapHelper
	 *
	 * @return  string  The field input markup.
	 *
	 */
	protected function getInput($bootstrapHelper = null)
	{
		$value = trim($this->value);

		// Add uk-radio if UIKit3 is used
		if ($bootstrapHelper && $bootstrapHelper->getFrameworkClass('uk-radio'))
		{
			$this->addClass('uk-radio');
		}

		/* Add form-check-input for bootstrap 4*/
		if ($bootstrapHelper && $bootstrapHelper->getFrameworkClass('form-check-input'))
		{
			$this->addClass('form-check-input');
		}

		$data = [
			'name'            => $this->name,
			'options'         => $this->options,
			'value'           => $value,
			'attributes'      => $this->buildAttributes(),
			'bootstrapHelper' => $bootstrapHelper,
			'row'             => $this->row,
		];

		return HelpdeskProHelperHtml::loadCommonLayout('fieldlayout/radio.php', $data);
	}
}