<?php
/**
 * Supports a custom field which display list of countries
 *
 * @package     Joomla.HDP
 * @subpackage  Form
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class HDPFormFieldCountries extends HDPFormFieldList
{

	/**
	 * The form field type.
	 *
	 * @var    string
	 */
	public $type = 'Countries';

	/**
	 * Method to get the custom field options.
	 * Use the query attribute to supply a query to generate the list.
	 *
	 * @return  array  The field option objects.
	 *
	 */
	protected function getOptions()
	{
		try
		{
			/* @var \Joomla\Database\DatabaseDriver $db */
			$db    = Factory::getContainer()->get('db');
			$query = $db->getQuery(true)
				->select('name AS `value`, name AS `text`')
				->from('#__jd_countries')
				->order('name');
			$db->setQuery($query);
			$options   = [];
			$options[] = HTMLHelper::_('select.option', '', Text::_('JD_SELECT_COUNTRY'));
			$options   = array_merge($options, $db->loadObjectList());
		}
		catch (Exception $e)
		{
			$options = [];
		}

		return $options;
	}
}
