<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Factory;

// Require the OSL library
if (!defined('OSL_INCLUDED') && !@include_once(JPATH_LIBRARIES . '/osl/init.php'))
{
	throw new RuntimeException('OSL library is not installed', 500);
}

// Register auto-loader
JLoader::registerPrefix('HDP', JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/libraries');
JLoader::register('HelpdeskProHelperBootstrap', JPATH_ROOT . '/components/com_helpdeskpro/Helper/bootstrap.php');
JLoader::registerAlias('HelpdeskProHelper', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Helper');
JLoader::registerAlias('HelpdeskProHelperHtml', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Html');
JLoader::registerAlias('HelpdeskProRoute', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Route');
JLoader::registerAlias('HelpdeskProHelperHtml', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Html');
JLoader::registerAlias('OSSolution\\HelpdeskPro\\Site\\Controller\\Ticket', 'OSSolution\\HelpdeskPro\\Admin\\Controller\\Ticket');
JLoader::registerAlias('OSSolution\\HelpdeskPro\\Site\\Model\\Tickets', 'OSSolution\\HelpdeskPro\\Admin\\Model\\Tickets');
JLoader::registerAlias('OSSolution\\HelpdeskPro\\Site\\Model\\Ticket', 'OSSolution\\HelpdeskPro\\Admin\\Model\\Ticket');

if (version_compare(JVERSION, '4.4.99', '>'))
{
	JLoader::registerAlias('JDatabaseQuery', \Joomla\Database\DatabaseQuery::class);
	JLoader::registerAlias('JDatabaseDriver', \Joomla\Database\DatabaseDriver::class);

	// Force autoload class to make it available for using
	class_exists('JDatabaseQuery');
	class_exists('JDatabaseDriver');
}

// Disable STRICT_TRANS_TABLES mode
/* @var \Joomla\Database\DatabaseDriver $db */
$db = Factory::getContainer()->get('db');
$db->setQuery("SET sql_mode=(SELECT REPLACE(@@sql_mode,'STRICT_TRANS_TABLES',''));");
$db->execute();

// Make necessary changes to request data before passing it to controller for processing
OSL\Utils\Helper::prepareRequestData();