<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

$config = HelpdeskProHelper::getConfig();

$this->includeTemplate('script');
?>
<form action="<?php echo $this->getFormAction(); ?>" method="post" name="adminForm" id="adminForm">
	<div id="j-main-container">
        <div id="filter-bar" class="btn-toolbar js-stools-container-filters-visible">
			<?php $this->renderSearchBar(); ?>
			<div class="btn-group pull-right hidden-phone">
				<?php
					echo HelpdeskProHelperHtml::getChoicesJsSelect($this->lists['filter_category_id']);

					if (isset($this->lists['filter_status_id']))
					{
						echo $this->lists['filter_status_id'];
					}

                    if (!empty($this->showStaffColumn))
                    {
                        echo $this->lists['filter_staff_id'];
                    }
				?>
			</div>
            <?php
                if (isset($this->lists['filter_priority_id']) || isset($this->lists['filter_label_id']) || count($this->filterableFields))
                {
                ?>
                <div class="btn-group pull-right hdp-filter-second-row">
                    <?php
                    if (isset($this->lists['filter_priority_id']))
                    {
                        echo $this->lists['filter_priority_id'];
                    }

                    if (isset($this->lists['filter_label_id']))
                    {
                        echo $this->lists['filter_label_id'];
                    }

                    // Display filterable custom field filters
                    foreach ($this->filterableFields as $filterableField)
                    {
                        if (isset($this->lists['filter_field_' . $filterableField->id]))
                        {
                            echo $this->lists['filter_field_' . $filterableField->id];
                        }
                    }
                    ?>
                </div>
                <?php
                }
            ?>
		</div>
		<div class="clearfix"></div>
		<table class="adminlist table table-striped">
			<thead>
			<tr>
				<th width="5">
					<?php echo Text::_('NUM'); ?>
				</th>
				<th width="20">
					<?php echo HTMLHelper::_('grid.checkall'); ?>
				</th>
				<th class="title" style="text-align: left;">
					<?php echo $this->gridSort('HDP_TITLE', 'tbl.subject'); ?>
				</th>
				<th class="title" style="text-align: left;">
					<?php echo $this->gridSort('HDP_CATEGORY', 'tbl.category_id'); ?>
				</th>
				<th class="title" style="text-align: left;">
					<?php echo $this->gridSort('HDP_USER', 'c.username'); ?>
				</th>
				<?php
                foreach ($this->fields as $field)
                {
                ?>
                    <th class="title">
                        <?php
                            if ($field->is_searchable)
                            {
                                echo $this->gridSort($field->title, 'tbl.' . $field->name);
                            }
                            else
                            {
                                echo $field->title;
                            }
                        ?>
                    </th>
                <?php
                }
				?>
				<th class="title">
					<?php echo $this->gridSort('HDP_CREATED_DATE', 'tbl.created_date'); ?>
				</th>
				<th class="title">
					<?php echo $this->gridSort('HDP_MODIFIED_DATE', 'tbl.modified_date'); ?>
				</th>
                <?php
                if (isset($this->lists['filter_status_id']))
                {
                ?>
                    <th width="8%">
                        <?php echo $this->gridSort('HDP_STATUS', 'tbl.status_id'); ?>
                    </th>
                <?php
                }

                if (isset($this->lists['filter_priority_id']))
                {
                ?>
                    <th width="8%">
                        <?php echo $this->gridSort('HDP_PRIORITY', 'tbl.priority_id'); ?>
                    </th>
                <?php
                }

                if (!empty($this->showStaffColumn))
				{
				?>
					<th width="8%">
						<?php echo $this->gridSort('HDP_STAFF', 'tbl.staff_id'); ?>
					</th>
				<?php
				}
				?>
				<th width="2%">
					<?php echo $this->gridSort('HDP_ID', 'tbl.id'); ?>
				</th>
			</tr>
			</thead>
			<tfoot>
			<tr>
				<td colspan="<?php echo 10 + count($this->fields); ?>">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
			</tfoot>
			<tbody>
			<?php
			$k = 0;
			
			for ($i = 0, $n = count($this->items); $i < $n; $i++)
			{
				$row     = $this->items[$i];
				$link = $this->getEditItemLink($row);
				$checked = HTMLHelper::_('grid.id', $i, $row->id);

				if ($row->user_id)
				{
					$accountLink = 'index.php?option=com_users&task=user.edit&id=' . $row->user_id;
				}

				if (!$row->staff_id)
				{
					$assignTicketClass = ' hdp-ticket-unassigned';
				}
				else
				{
					$assignTicketClass = '';
				}

				?>
				<tr class="<?php echo "row$k"; ?> hdp-ticket-status-<?php echo $row->status_id . $assignTicketClass; ?>">
					<td>
						<?php echo $this->pagination->getRowOffset($i); ?>
					</td>
					<td>
						<?php echo $checked; ?>
					</td>
					<td>
						<a href="<?php echo $link; ?>"><?php echo $row->subject; ?></a>
						<?php
						if ($row->label_id)
						{
							?>
							<span class="label_box"
							      style="background-color: #<?php echo $row->color_code; ?>"><?php echo $row->label_title; ?></span>
							<?php
						}
						?>
					</td>
					<td>
						<?php echo $row->category_title; ?>
					</td>
					<td>
						<span class="submitter_name"><?php echo $row->name; ?>
							<?php
							if ($row->username)
							{
							?>
								<a href="<?php echo $accountLink; ?>"
								   title="View Profile"><span>[<strong><?php echo $row->username; ?></strong>]</span></a>
							<?php
							}
							?>
						</span>
						<span class="submitter_email"><a
								href="mailto:<?php echo $row->email; ?>"><?php echo $row->email; ?></a></span>
					</td>
					<?php
                    foreach ($this->fields as $field)
                    {
                        $fieldValue = $this->fieldValues[$row->id][$field->id] ?? '';

                        if ($fieldValue && $field->fieldtype == 'Date')
                        {
	                        try
	                        {
		                        $fieldValue = HTMLHelper::_('date', $fieldValue, $config->date_format);
	                        }
	                        catch (Exception $e)
	                        {
		                        // Might happen because date is in wrong format
	                        }
                        }
                    ?>
                        <td>
                            <?php echo $fieldValue; ?>
                        </td>
                    <?php
                    }
					?>
					<td align="center">
						<?php echo HTMLHelper::_('date', $row->created_date, $this->config->date_format); ?>
					</td>
					<td align="center">
						<?php echo HTMLHelper::_('date', $row->modified_date, $this->config->date_format); ?>
					</td>
                    <?php
                        if (isset($this->lists['filter_status_id']))
                        {
                        ?>
                            <td>
	                            <?php echo $this->statusList[$row->status_id] ?? ''; ?>
                            </td>
                        <?php
                        }

                        if (isset($this->lists['filter_priority_id']))
                        {
                        ?>
                            <td>
	                            <?php echo $this->priorityList[$row->priority_id]; ?>
                            </td>
                        <?php
                        }

                        if (!empty($this->showStaffColumn))
                        {
                        ?>
                            <td>
                                <?php echo $this->staffs[$row->staff_id] ?? ''; ?>
                            </td>
                        <?php
                        }
					?>
					<td align="center">
						<?php echo $row->id; ?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
		</table>
	</div>
	<?php $this->renderFormHiddenVariables(); ?>
</form>