<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

$editor = Editor::getInstance(Factory::getApplication()->get('editor'));

$assetVersion = HelpdeskProHelper::getInstalledVersion();

$wa = Factory::getApplication()
	->getDocument()
	->addScriptOptions('ticketsUrl', 'index.php?option=com_helpdeskpro&view=tickets')
	->getWebAssetManager()
	->useScript('keepalive');

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$wa->registerAndUseScript(
		'com_helpdeskpro.helpdeskpro.bbcode',
		'media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js',
		['version' => $assetVersion]
	);
}

OSSolution\HelpdeskPro\Site\Helper\Jquery::validateForm();

$wa->registerAndUseScript('com_helpdeskpro.admin-ticket-form', 'media/com_helpdeskpro/js/admin-ticket-form.js', ['version' => $assetVersion]);
?>
<div class="hdp-container hpd-joomla4-container">
	<form class="form form-horizontal" name="adminForm" id="adminForm" action="index.php" method="post"
	      enctype="multipart/form-data">
        <?php
            if (!$this->item->user_id)
            {
            ?>
                <div class="control-group">
                    <div class="control-label"><?php echo Text::_('HDP_NAME'); ?><span class="required">*</span></div>
                    <div class="controls">
                        <input type="text" id="name" name="name" placeholder="<?php echo Text::_('HDP_CUSTOMER_NAME'); ?>" value="<?php echo $this->item->name; ?>" class="input-xxlarge form-control validate[required]"/>
                    </div>
                </div>
                <div class="control-group">
                    <div class="control-label"><?php echo Text::_('HDP_EMAIL'); ?><span class="required">*</span></div>
                    <div class="controls">
                        <input type="text" id="email" name="email" placeholder="<?php echo Text::_('HDP_CUSTOMER_EMAIL'); ?>" value="<?php echo $this->item->email; ?>" class="input-xxlarge form-control validate[required,custom[email]]"/>
                    </div>
                </div>
            <?php
            }
			else
			{
				// Allow changing user
			?>
				<div class="control-group">
					<div class="control-label"><?php echo Text::_('HDP_USER'); ?><span class="required">*</span></div>
					<div class="controls">
						<?php echo HelpdeskProHelperHtml::getUserInput($this->item->user_id, 'user_id'); ?>
					</div>
				</div>
			<?php
			}
        ?>
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_CATEGORY'); ?><span
					class="required">*</span></div>
			<div class="controls">
				<?php echo HelpdeskProHelperHtml::getChoicesJsSelect($this->lists['category_id']); ?>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_SUBJECT'); ?><span
					class="required">*</span></div>
			<div class="controls">
				<input type="text" id="subject" name="subject" class="input-xxlarge form-control validate[required]" value="<?php echo htmlspecialchars($this->item->subject, ENT_COMPAT, 'UTF-8'); ?>" size="50"/>
			</div>
		</div>
		<?php
		if (isset($this->lists['priority_id']))
		{
		?>
			<div class="control-group">
				<div class="control-label"><?php echo Text::_('HDP_PRIORITY'); ?><span
							class="required">*</span></div>
				<div class="controls">
					<?php echo $this->lists['priority_id']; ?>
				</div>
			</div>
		<?php
		}

		$fields = $this->form->getFields();

		// Make bootstrap helper works for Joomla 4 backend
		$this->bootstrapHelper->addClassMapping('control-group', 'control-group')
			->addClassMapping('control-label', 'control-label')
			->addClassMapping('controls', 'controls');

		/* @var HDPFormField $field*/
		foreach ($fields as $field)
		{
			echo $field->getControlGroup(true, $this->bootstrapHelper);
		}
		?>
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_MESSAGE'); ?><span class="required">*</span></div>
			<div class="controls">
				<?php
				if ($this->config->use_html_editor)
				{
					echo $editor->display('message', $this->item->message, '100%', '350', '75', '10', false);
				}
				else
				{
				?>
					<textarea rows="10" cols="70" name="message" class="hdp_fullwidth form-control validate[required]"><?php echo htmlspecialchars($this->item->message, ENT_COMPAT, 'UTF-8'); ?></textarea>
				<?php
				}
				?>
			</div>
		</div>
		<input type="hidden" name="option" value="com_helpdeskpro"/>
		<input type="hidden" name="task" value="ticket.save"/>
        <input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>