<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Ticket;

use HelpdeskProHelperBootstrap;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Database\DatabaseDriver;
use OSL\View\ItemView;
use OSSolution\HelpdeskPro\Admin\Model\Ticket;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

/**
 * @property Ticket $model
 */
class Html extends ItemView
{
	use Common;

	/**
	 * List of labels
	 *
	 * @var array
	 */
	protected $rowLabels;

	/**
	 * The date format
	 *
	 * @var string
	 */
	protected $dateFormat;

	/**
	 * Get list of users current online
	 *
	 * @var array
	 */
	protected $onlineUserIds;

	/**
	 * Flag to mark if this ticket could be converted to KB
	 *
	 * @var bool
	 */
	protected $canConvertToKb;

	/**
	 * Captcha is not used in backend, so it is always valid
	 *
	 * @var bool
	 */
	protected $captchaInvalid = false;

	/**
	 * Get extra data needed to render the form
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		// Remove the uploaded files data from section
		$this->container->session->clear('hdp_uploaded_files');
		$this->container->session->clear('hdp_uploaded_files_original_names');
		$this->bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();

		$layout = $this->getLayout();

		if ($layout == 'form')
		{
			// Render form to allow submitting ticket
			$this->beforeRenderTicketForm();

			return;
		}
		elseif ($layout == 'edit')
		{
			// Render form to allow editing ticket
			$this->beforeRenderTicketEditForm();

			return;
		}

		// Render ticket details page
		if (empty($this->item->id))
		{
			// Invalid ticket, redirect to ticket list page
			$app = Factory::getApplication();

			$app->enqueueMessage(Text::_('HDP_TICKET_NOT_EXISTS'), 'warning');
			$app->redirect('index.php?option=com_helpdeskpro&view=tickets');
		}

		$config = HelpdeskProHelper::getConfig();
		$rows   = HelpdeskProHelperDatabase::getAllCategories();

		$this->prepareDisplayTicketData($this->item, $rows);

		/* @var DatabaseDriver $db */
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('category_type')
			->from('#__helpdeskpro_categories')
			->where('id = ' . (int) $this->item->category_id);
		$db->setQuery($query);
		$categoryType = $db->loadResult();

		if ($categoryType == 0)
		{
			$canConvertToKb = true;
		}
		else
		{
			$canConvertToKb = false;
		}

		$this->rowLabels      = HelpdeskProHelperDatabase::getAllLabels();
		$this->onlineUserIds  = HelpdeskProHelper::getOnlineUsers();
		$this->dateFormat     = $config->date_format;
		$this->canConvertToKb = $canConvertToKb;
	}

	/**
	 * Generate form allows admin create new ticket
	 *
	 * @return void
	 */
	private function beforeRenderTicketForm()
	{
		$config = HelpdeskProHelper::getConfig();

		$this->prepareSubmitTicketFormData();

		$options   = [];
		$options[] = HTMLHelper::_('select.option', -1, Text::_('HDP_APPLY_LABEL'), 'id', 'title');
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_NO_LABEL'), 'id', 'title');
		$options   = array_merge($options, HelpdeskProHelperDatabase::getAllLabels());

		$this->lists['label_id'] = HTMLHelper::_('select.genericlist', $options, 'label_id', [
			'option.text.toHtml' => false,
			'option.text'        => 'title',
			'option.key'         => 'id',
			'list.attr'          => 'class="form-select"',
			'list.select'        => $config->default_ticket_priority_id,
		]);
	}

	/**
	 * Generate form allows admin edit a ticket
	 *
	 * @return void
	 */
	private function beforeRenderTicketEditForm()
	{
		$fieldSuffix = HelpdeskProHelper::getFieldSuffix($this->item->language);

		$rows = HelpdeskProHelperDatabase::getAllCategories(
			'ordering',
			[],
			$fieldSuffix
		);

		$options   = [];
		$options[] = HTMLHelper::_('select.option', -1, Text::_('HDP_APPLY_LABEL'), 'id', 'title');
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_NO_LABEL'), 'id', 'title');
		$options   = array_merge($options, HelpdeskProHelperDatabase::getAllLabels());

		$this->lists['label_id'] = HTMLHelper::_('select.genericlist', $options, 'label_id', [
			'option.text.toHtml' => false,
			'option.text'        => 'title',
			'option.key'         => 'id',
			'list.attr'          => 'class="form-select"',
			'list.select'        => $this->item->label_id,
		]);

		$this->prepareEditTicketFormData($this->item, $rows);
	}

	/**
	 * Override default toolbar buttons
	 */
	protected function addToolbar()
	{
		if ($this->item->id)
		{
			$toolbarTitle = $this->container->languagePrefix . '_' . $this->name . '_VIEW';
		}
		else
		{
			$toolbarTitle = $this->container->languagePrefix . '_' . $this->name . '_NEW';
		}

		ToolbarHelper::title(Text::_(strtoupper($toolbarTitle)));

		if ($this->layout == 'edit')
		{
			ToolbarHelper::save('ticket.save');
		}

		if ($this->item->id && $this->layout === 'default')
		{
			ToolbarHelper::link(
				Route::_('index.php?option=com_helpdeskpro&view=tickets', false),
				Text::_('HDP_TICKETS_LIST')
			);
		}
		else
		{
			ToolbarHelper::cancel('ticket.cancel');
		}
	}
}