<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;

$translatable = Multilanguage::isEnabled() && count($this->languages);

Factory::getApplication()
	->getDocument()
	->getWebAssetManager()
	->registerAndUseScript('com_helpdeskpro.colorpicker', 'media/com_helpdeskpro/admin/assets/js/colorpicker/jscolor.js')
?>
<form action="index.php?option=com_helpdeskpro&view=status" method="post" name="adminForm" id="adminForm" class="form form-horizontal">
    <?php
        if ($translatable)
        {
            echo HTMLHelper::_('uitab.startTabSet', 'status', ['active' => 'general-page']);
            echo HTMLHelper::_('uitab.addTab', 'status', 'general-page', Text::_('HDP_GENERAL', true));
        }
    ?>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_TITLE'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="title" id="title" size="40" maxlength="250"
                       value="<?php echo $this->item->title; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_BG_COLOR'); ?>
            </div>
            <div class="controls">
                <input type="text" name="bgcolor" class="form-control color {required:false}"
                       value="<?php echo $this->item->bgcolor; ?>" size="10"/>
                <?php echo Text::_('HDP_BG_COLOR_EXPLAIN'); ?>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_PUBLISHED'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['published']; ?>
            </div>
        </div>
		<?php
		if ($translatable)
		{
			echo HTMLHelper::_('uitab.endTab');
			echo $this->loadTemplate('translation');
			echo HTMLHelper::_('uitab.endTabSet');
		}
		?>
		<?php echo HTMLHelper::_('form.token'); ?>
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
		<input type="hidden" name="task" value=""/>
</form>