<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;

ToolbarHelper::title(Text::_('Tickets report'), 'generic.png');
HTMLHelper::_('bootstrap.tooltip', '.hasTooltip', ['html' => true, 'sanitize' => false, 'placement' => 'top']);

function sortTickets($a, $b)
{
	if ($a->total_tickets == $b->total_tickets)
	{
		return 0;
	}

	return ($a->total_tickets > $b->total_tickets) ? -1 : 1;
}

function sortTicketsByManager($a, $b)
{
	if ($a['total_tickets'] == $b['total_tickets'])
	{
		return 0;
	}

	return ($a['total_tickets'] > $b['total_tickets']) ? -1 : 1;
}
?>
<div id="j-main-container">
	<form action="index.php?option=com_helpdeskpro&view=report" method="post" name="adminForm" id="adminForm">
		<table width="100%">
			<tr>
				<td align="left">
					<?php echo $this->lists['filter_date_range']; ?>
				</td>
			</tr>
		</table>
		<div id="editcell">
			<h2><?php echo Text::_('HDP_TICKET_BY_MANAGERS'); ?></h2>
			<table class="adminlist table table-striped">
				<thead>
				<tr>
					<th>
						<?php echo Text::_('HDP_MANAGER'); ?>
					</th>
					<?php
					$statuses = $this->data['statuses'];
					foreach ($statuses as $status)
					{
						?>
						<th>
							<?php echo $status->title; ?>
						</th>
						<?php
					}
					?>
					<th>
						<?php echo Text::_('HDP_TOTAL_TICKETS'); ?>
					</th>
				</tr>
				</thead>
				<tbody>
				<?php
				$managers = $this->data['managers'];
				usort($managers, 'sortTicketsByManager');
				foreach ($managers as $manager)
				{
					?>
					<tr>
						<td>
							<?php echo $manager['name']; ?>
						</td>
						<?php
						foreach ($statuses as $status)
						{
							?>
							<td>
								<?php
								if (isset($manager[$status->id]))
								{
									echo $manager[$status->id];
								}
								else
								{
									echo 0;
								}
								?>
							</td>
							<?php
						}
						?>
						<td>
							<?php echo $manager['total_tickets']; ?>
						</td>
					</tr>
					<?php
				}
				?>
				</tbody>
			</table>
			<h2><?php echo Text::_('HDP_TICKET_BY_STAFFS'); ?></h2>
			<table class="adminlist table table-striped">
				<thead>
				<tr>
					<th>
						<?php echo Text::_('HDP_STAFF'); ?>
					</th>
					<?php
					$statuses = $this->data['statuses'];
					foreach ($statuses as $status)
					{
						?>
						<th>
							<?php echo $status->title; ?>
						</th>
						<?php
					}
					?>
					<th>
						<?php echo Text::_('HDP_TOTAL_TICKETS'); ?>
					</th>
				</tr>
				</thead>
				<tbody>
				<?php
				$staffs = $this->data['staffs'];
				usort($staffs, 'sortTickets');
				foreach ($staffs as $staff)
				{
					?>
					<tr>
						<td>
							<?php echo $staff->username; ?>
						</td>
						<?php
						foreach ($statuses as $status)
						{
							?>
							<td>
								<?php
								if (isset($staff->status[$status->id]))
								{
									echo $staff->status[$status->id];
								}
								else
								{
									echo 0;
								}
								?>
							</td>
							<?php
						}
						?>
						<td>
							<?php echo $staff->total_tickets; ?>
						</td>
					</tr>
					<?php
				}
				?>
				</tbody>
			</table>
			<h2><?php echo Text::_('HDP_TICKET_BY_CATEGORIES'); ?></h2>
			<table class="adminlist table table-striped">
				<thead>
				<tr>
					<th>
						<?php echo Text::_('Category'); ?>
					</th>
					<?php
					$statuses = $this->data['statuses'];
					foreach ($statuses as $status)
					{
						?>
						<th>
							<?php echo $status->title; ?>
						</th>
						<?php
					}
					?>
					<th>
						<?php echo Text::_('Total Tickets'); ?>
					</th>
				</tr>
				</thead>
				<tbody>
				<?php
				$categories = $this->data['categories'];
				usort($categories, 'sortTickets');
				foreach ($categories as $category)
				{
					if (!$category->total_tickets)
					{
						continue;
					}
					?>
					<tr>
						<td>
							<?php echo $category->title; ?>
						</td>
						<?php
						foreach ($statuses as $status)
						{
							?>
							<td>
								<?php
								if (isset($category->status[$status->id]))
								{
									echo $category->status[$status->id];
								}
								else
								{
									echo 0;
								}
								?>
							</td>
							<?php
						}
						?>
						<td>
							<?php echo $category->total_tickets; ?>
						</td>
					</tr>
					<?php
				}
				?>
				</tbody>
			</table>
		</div>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>