<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Report;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\View\HtmlView;

defined('_JEXEC') or die;

class Html extends HtmlView
{
	/**
	 * The sidebar data
	 *
	 * @var string
	 */

	protected $sidebar;

	/**
	 * Array hold data ranger filter
	 *
	 * @var array
	 */
	protected $lists = [];

	/**
	 * Array hold calculated reporting data
	 *
	 * @var array
	 */
	protected $data;

	/**
	 * Prepare data to show on report page
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		$options   = [];
		$options[] = HTMLHelper::_('select.option', '', Text::_('HDP_CHOOSE_DATE_RANGE'));
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_TODAY'));
		$options[] = HTMLHelper::_('select.option', 1, Text::_('HDP_THIS_WEEK'));
		$options[] = HTMLHelper::_('select.option', 2, Text::_('HDP_THIS_MONTH'));
		$options[] = HTMLHelper::_('select.option', 3, Text::_('HDP_THIS_YEAR'));
		$options[] = HTMLHelper::_('select.option', 4, Text::_('HDP_ALL'));

		$this->lists['filter_date_range'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'filter_date_range',
			'onchange="submit();" class="form-select"',
			'value',
			'text',
			$this->model->getState('filter_date_range')
		);

		$this->data = $this->model->getData();
	}
}