<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Reply;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\View\ItemView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;

defined('_JEXEC') or die;

class Html extends ItemView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		$rows     = HelpdeskProHelperDatabase::getAllCategories();
		$children = [];

		if ($rows)
		{
			// first pass - collect children
			foreach ($rows as $v)
			{
				$pt   = (int) $v->parent_id;
				$list = @$children[$pt] ? $children[$pt] : [];
				array_push($list, $v);
				$children[$pt] = $list;
			}
		}

		$list      = HTMLHelper::_('menu.treerecurse', 0, '', [], $children, 9999, 0, 0);
		$options   = [];
		$options[] = HTMLHelper::_('select.option', -1, Text::_('HDP_ALL'));

		foreach ($list as $listItem)
		{
			$options[] = HTMLHelper::_('select.option', $listItem->id, $listItem->treename);
		}

		$this->lists['category_id'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'category_id',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'text',
				'option.value'       => 'value',
				'list.attr'          => 'class="form-select"',
				'list.select'        => $this->item->category_id,
			]
		);
	}
}