<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Field;

use Joomla\CMS\Factory;
use OSL\View\HtmlView;

defined('_JEXEC') or die;

class Raw extends HtmlView
{
	/**
	 * Options from the selected custom field
	 *
	 * @var array
	 */
	protected $options;

	/**
	 * Display options from selected field
	 *
	 * @return void
	 * @throws \Exception
	 */
	public function display()
	{
		$this->setLayout('options');

		$fieldId = Factory::getApplication()->getInput()->getInt('field_id', 0);

		/* @var \Joomla\Database\DatabaseDriver $db */
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('`values`')
			->from('#__helpdeskpro_fields')
			->where('id = ' . $fieldId);
		$db->setQuery($query);
		$options       = explode("\r\n", $db->loadResult());
		$this->options = $options;

		parent::display();
	}
}