<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Field;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Database\ParameterType;
use OSL\View\ItemView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;

defined('_JEXEC') or die;

class Html extends ItemView
{
	/**
	 * The options which the current custom field depends on
	 *
	 * @var array
	 */
	protected $dependOnOptions = [];

	/**
	 * The options from the parent/master field
	 *
	 * @var array
	 */
	protected $dependOptions = [];

	/**
	 * Prepare view data before displaying
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		$fieldTypes = [
			'Text',
			'Url',
			'Email',
			'Textarea',
			'List',
			'Checkboxes',
			'Radio',
			'Date',
			'Heading',
			'Message',
		];

		$options   = [];
		$options[] = HTMLHelper::_('select.option', -1, Text::_('HDP_FIELD_TYPE'));

		foreach ($fieldTypes as $fieldType)
		{
			$options[] = HTMLHelper::_('select.option', $fieldType, $fieldType);
		}

		$this->lists['fieldtype'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'fieldtype',
			'class="form-select"',
			'value',
			'text',
			$this->item->fieldtype
		);

		$rows     = HelpdeskProHelperDatabase::getAllCategories();
		$children = [];

		if ($rows)
		{
			// first pass - collect children
			foreach ($rows as $v)
			{
				$pt   = (int) $v->parent_id;
				$list = @$children[$pt] ? $children[$pt] : [];
				array_push($list, $v);
				$children[$pt] = $list;
			}
		}

		$list      = HTMLHelper::_('menu.treerecurse', 0, '', [], $children, 9999, 0, 0);
		$options   = [];
		$options[] = HTMLHelper::_('select.option', -1, Text::_('HDP_ALL_CATEGORIES'));

		foreach ($list as $listItem)
		{
			$options[] = HTMLHelper::_('select.option', $listItem->id, $listItem->treename);
		}

		$selectedCategories = [-1];

		if ($this->item->id && $this->item->category_id != -1)
		{
			$db    = $this->container->db;
			$query = $db->getQuery(true);
			$query->select('category_id')
				->from('#__helpdeskpro_field_categories')
				->where('field_id = ' . $this->item->id);
			$db->setQuery($query);
			$selectedCategories = $db->loadColumn();
			$query->clear();
		}

		$this->lists['category_id'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'category_id[]',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'text',
				'option.value'       => 'value',
				'list.attr'          => 'multiple="multiple" size="6" class="form-select"',
				'list.select'        => $selectedCategories,
			]
		);

		$options                          = [];
		$options[]                        = HTMLHelper::_('select.option', 1, Text::_('Yes'));
		$options[]                        = HTMLHelper::_('select.option', 2, Text::_('No'));
		$this->lists['required']          = HTMLHelper::_(
			'select.booleanlist',
			'required',
			' class="form-select" ',
			$this->item->required
		);
		$this->lists['show_in_list_view'] = HTMLHelper::_(
			'select.booleanlist',
			'show_in_list_view',
			' class="form-select" ',
			$this->item->show_in_list_view
		);

		$this->lists['is_filterable'] = HTMLHelper::_(
			'select.booleanlist',
			'is_filterable',
			' class="form-select" ',
			$this->item->is_filterable
		);

		$options                            = [];
		$options[]                          = HTMLHelper::_('select.option', 0, Text::_('None'));
		$options[]                          = HTMLHelper::_('select.option', 1, Text::_('Integer Number'));
		$options[]                          = HTMLHelper::_('select.option', 2, Text::_('Number'));
		$options[]                          = HTMLHelper::_('select.option', 3, Text::_('Email'));
		$options[]                          = HTMLHelper::_('select.option', 4, Text::_('Url'));
		$options[]                          = HTMLHelper::_('select.option', 5, Text::_('Phone'));
		$options[]                          = HTMLHelper::_('select.option', 6, Text::_('Past Date'));
		$options[]                          = HTMLHelper::_('select.option', 7, Text::_('Ip'));
		$options[]                          = HTMLHelper::_('select.option', 8, Text::_('Min size'));
		$options[]                          = HTMLHelper::_('select.option', 9, Text::_('Max size'));
		$options[]                          = HTMLHelper::_('select.option', 10, Text::_('Min integer'));
		$options[]                          = HTMLHelper::_('select.option', 11, Text::_('Max integer'));
		$this->lists['datatype_validation'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'datatype_validation',
			'class="form-select"',
			'value',
			'text',
			$this->item->datatype_validation
		);

		$this->lists['multiple'] = HTMLHelper::_(
			'select.booleanlist',
			'multiple',
			' class="form-select" ',
			$this->item->multiple
		);

		$db    = $this->model->getDbo();
		$query = $db->getQuery(true)
			->select('id, title')
			->from('#__helpdeskpro_fields')
			->whereIn('fieldtype', ['List', 'Radio', 'Checkboxes'], ParameterType::STRING)
			->where('published = 1')
			->order('title');

		if ($this->item->id)
		{
			$query->where('id != ' . $this->item->id);
		}

		$db->setQuery($query);
		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('Select'));

		foreach ($db->loadObjectList() as $field)
		{
			$options[] = HTMLHelper::_('select.option', $field->id, '[' . $field->id . '] - ' . $field->title);
		}

		$this->lists['depend_on_field_id'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'depend_on_field_id',
			'class="form-select"',
			'value',
			'text',
			$this->item->depend_on_field_id
		);

		$this->dependOptions = [];

		if ($this->item->depend_on_field_id)
		{
			//Get the selected options
			$this->dependOnOptions = json_decode($this->item->depend_on_options);
			$query->clear()
				->select('`values`')
				->from('#__helpdeskpro_fields')
				->where('id = ' . $this->item->depend_on_field_id);
			$db->setQuery($query);
			$this->dependOptions = explode("\r\n", $db->loadResult());
		}
	}
}