<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\EmailLogs;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use OSL\Config\Config;
use OSL\Container\Container;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Site\Helper\Helper;

defined('_JEXEC') or die;

class Html extends ListView
{
	/**
	 * Email Types
	 *
	 * @var array
	 */
	protected $emailTypes;

	/**
	 * Component config
	 *
	 * @var Config
	 */
	protected $config;

	/**
	 * Constructor
	 *
	 * @param   Container  $container
	 * @param   array      $config
	 */
	public function __construct(Container $container, $config = [])
	{
		$config['hide_buttons'] = ['add', 'edit', 'publish'];

		parent::__construct($container, $config);
	}

	/**
	 * Prepare view data
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		$this->emailTypes = [
			'new_ticket_notification_email' => Text::_('HDP_NEW_TICKET_NOTIFICATION_EMAIL'),
			'ticket_updated_email'          => Text::_('HDP_TICKET_UPDATED_EMAIL'),
			'ticket_assigned_email'         => Text::_('HDP_TICKET_ASSIGNED_EMAIL'),
			'ticket_status_changed_email'   => Text::_('HDP_TICKET_STATUS_CHANGED_EMAIL'),
			'ticket_closed_email'           => Text::_('HDP_TICKET_CLOSED_EMAIL'),
			'internal_comment_added_email'  => Text::_('HDP_INTERNAL_COMMENT_ADDED_EMAIL'),
		];

		$options   = [];
		$options[] = HTMLHelper::_('select.option', '', Text::_('HDP_EMAIL_TYPE'));

		foreach ($this->emailTypes as $key => $value)
		{
			$options[] = HTMLHelper::_('select.option', $key, $value);
		}

		$this->lists['filter_email_type'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'filter_email_type',
			'class="form-select" onchange="submit();"',
			'value',
			'text',
			$this->state->filter_email_type
		);

		$this->config = Helper::getConfig();
	}

	/**
	 * Custom toolbar buttons
	 *
	 * @return void
	 */
	protected function addCustomToolbarButtons()
	{
		ToolbarHelper::trash('delete_all', 'HDP_DELETE_ALL', false);
	}
}