<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

$config = HelpdeskProHelper::getConfig();

$rowStatuses = HelpdeskProHelperDatabase::getAllStatuses();
$statusList = [];

foreach ($rowStatuses as $status)
{
	$statusList[$status->id] = $status->title;
}

$statusBgClassMapping = [
	$config->new_ticket_status_id                    => 'badge bg-primary',
	$config->ticket_status_when_customer_add_comment => 'badge bg-danger',
	$config->ticket_status_when_admin_add_comment    => 'badge bg-info',
	$config->closed_ticket_status                    => 'badge bg-success',
];
?>
<table class="table table-striped table-bordered">
	<thead>
		<tr>
			<th class="title"><?php echo Text::_('HDP_TICKET'); ?></th>
			<th class="title"><?php echo Text::_('HDP_CATEGORY'); ?></th>
			<th class="title"><?php echo Text::_('HDP_USER'); ?></th>
			<th class="center"><?php echo Text::_('HDP_CREATED_DATE'); ?></th>
			<th class="center"><?php echo Text::_('HDP_MODIFIED_DATE'); ?></th>
			<th class="title"><?php echo Text::_('HDP_STATUS'); ?></th>
			<th class="title" width="2%"><?php echo Text::_('HDP_ID'); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		foreach ($this->latestTickets as $row)
		{
			$link = Route::_('index.php?option=com_helpdeskpro&view=ticket&id=' . $row->id);

			if ($row->user_id)
			{
				$accountLink = 'index.php?option=com_users&task=user.edit&id=' . $row->user_id;
			}
			else
			{
				$accountLink = '';
			}
		?>
			<tr>
				<td>
					<a href="<?php echo $link; ?>"><?php echo $row->subject; ?></a>
				</td>
				<td>
					<?php echo $row->category_title; ?>
				</td>
				<td>
					<div class="submitter_name"><?php echo $row->name; ?>
						<?php
						if ($row->username)
						{
						?>
							<a href="<?php echo $accountLink; ?>" title="View Profile"><span>[<strong><?php echo $row->username; ?></strong>]</span></a>
						<?php
						}
						?>
					</div>
					<div class="submitter_email"><a href="mailto:<?php echo $row->email; ?>"><?php echo $row->email; ?></a></div>
				</td>
				<td class="center">
					<?php echo HTMLHelper::_('date', $row->created_date, $config->date_format); ?>
				</td>
				<td class="center">
					<?php echo HTMLHelper::_('date', $row->modified_date, $config->date_format); ?>
				</td>
				<td>
					<?php
					if (isset($statusList[$row->status_id]))
					{
						echo '<span class="' . ($statusBgClassMapping[$row->status_id] ?? 'badge bg-secondary') . '">' . $statusList[$row->status_id] . '</span>';;
					}
					?>
				</td>
				<td><?php echo $row->id; ?></td>
			</tr>
		<?php
		}
		?>
	</tbody>
</table>
