<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Language\Text;
use OSL\Utils\Html as HtmlUtils;

?>
<div class="control-group">
	<div class="control-label">
		<?php echo HtmlUtils::getFieldLabel('enable_api', Text::_('HDP_ENABLE_API'), Text::_('HDP_ENABLE_API_EXPLAIN')); ?>
	</div>
	<div class="controls">
		<?php echo HtmlUtils::getBooleanInput('enable_api', $this->config->get('enable_api', 0)); ?>
	</div>
</div>
<div class="control-group">
	<div class="control-label">
		<?php echo HtmlUtils::getFieldLabel('api_key', Text::_('HDP_API_KEY'), Text::_('HDP_API_KEY_EXPLAIN')); ?>
	</div>
	<div class="controls">
		<input type="text" name="api_key" class="input-xlarge form-control" value="<?php echo $this->config->api_key; ?>" />
	</div>
</div>
