<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;


$editor       = Editor::getInstance(Factory::getApplication()->get('editor'));
$translatable = Multilanguage::isEnabled() && count($this->languages);
?>
<form action="index.php?option=com_helpdeskpro&view=category" method="post" name="adminForm" id="adminForm" class="form form-horizontal">
		<?php
	        echo HTMLHelper::_('uitab.startTabSet', 'category', ['active' => 'general-page']);
	        echo HTMLHelper::_('uitab.addTab', 'category', 'general-page', Text::_('HDP_GENERAL', true));
        ?>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_TITLE'); ?>
                </div>
                <div class="controls">
                    <input class="form-control" type="text" name="title" id="title" size="40" maxlength="250"
                           value="<?php echo $this->item->title; ?>"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_ALIAS'); ?>
                </div>
                <div class="controls">
                    <input class="form-control" type="text" name="alias" id="alias" size="40" maxlength="250"
                           value="<?php echo $this->item->alias; ?>"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_PARENT_CATEGORY'); ?>
                </div>
                <div class="controls">
                    <?php echo HelpdeskProHelperHtml::getChoicesJsSelect($this->lists['parent_id']); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_ACCESS_LEVEL'); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['access']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_DESCRIPTION'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('description', $this->item->description, '100%', '350', '75', '10'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_CATEGORY_TYPE'); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['category_type']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_PUBLISHED'); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['published']; ?>
                </div>
            </div>
        <?php
        echo HTMLHelper::_('uitab.endTab');

		// Manage tab
        echo HTMLHelper::_('uitab.addTab', 'category', 'managers-page', Text::_('HDP_MANAGERS', true));
		echo $this->loadTemplate('managers');
        echo HTMLHelper::_('uitab.endTab');

        if ($translatable)
        {
	        echo $this->loadTemplate('translation', ['editor' => $editor]);
        }

        echo HTMLHelper::_('uitab.endTabSet');
		?>
		<?php echo HTMLHelper::_('form.token'); ?>
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
		<input type="hidden" name="task" value=""/>
</form>