<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Category;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Database\ParameterType;
use OSL\View\ItemView;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

// no direct access
defined('_JEXEC') or die;

class Html extends ItemView
{
	/**
	 * Manager User IDs of the category
	 *
	 * @var array
	 */
	protected $manageUserIds = [];

	/**
	 * Prepare view data before rendering
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		$db    = $this->container->db;
		$query = $db->getQuery(true)
			->select('*')
			->from('#__helpdeskpro_categories')
			->order('title');
		$db->setQuery($query);
		$rows = $db->loadObjectList();

		$this->lists['parent_id'] = HelpdeskProHelperHtml::buildCategoryDropdown(
			$this->item->parent_id,
			'parent_id',
			'class="form-select"',
			$rows
		);

		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_BOTH'));
		$options[] = HTMLHelper::_('select.option', 1, Text::_('HDP_TICKETS'));
		$options[] = HTMLHelper::_('select.option', 2, Text::_('HDP_KNOWLEDGE_BASE'));

		$this->lists['category_type'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'category_type',
			'class="form-select"',
			'value',
			'text',
			$this->item->category_type
		);

		if ($this->item->managers)
		{
			$managers = array_map('trim', explode(',', $this->item->managers));

			$query->clear()
				->select('id')
				->from('#__users')
				->whereIn('username', $managers, ParameterType::STRING);
			$db->setQuery($query);
			$this->manageUserIds = $db->loadColumn();
		}
	}
}