<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

$this->includeTemplate('script');

$this->ordering = [];

if (count($this->items))
{
	foreach ($this->items as $item)
	{
		$this->ordering[$item->parent_id][] = $item->id;
	}
}
?>
<form action="<?php echo $this->getFormAction(); ?>" method="post" name="adminForm" id="adminForm">
	<div id="j-main-container">
        <div id="filter-bar" class="btn-toolbar js-stools js-stools-container-filters-visible">
			<?php $this->renderSearchBar(); ?>
			<div class="btn-group pull-right hidden-phone">
				<?php echo HelpdeskProHelperHtml::getChoicesJsSelect($this->lists['filter_parent_id']); ?>
				<?php echo $this->lists['filter_category_type']; ?>
				<?php echo $this->lists['filter_state']; ?>
			</div>
		</div>
		<div class="clearfix"></div>
		<table class="adminlist table table-striped" id="categoryList">
			<thead>
			<tr>
				<th width="1%" class="nowrap center hidden-phone">
					<?php echo $this->searchToolsSortHeader(); ?>
				</th>
				<th width="20">
					<?php echo HTMLHelper::_('grid.checkall'); ?>
				</th>
				<th class="title">
					<?php echo $this->searchToolsSort('HDP_TITLE', 'tbl.title'); ?>
				</th>
				<th class="title">
					<?php echo $this->searchToolsSort('HDP_CATEGORY_TYPE', 'tbl.category_type'); ?>
				</th>
				<th class="title" width="15%">
					<?php echo Text::_('HDP_NUMBER_TICKETS'); ?>
				</th>
				<th width="5%">
					<?php echo $this->searchToolsSort('HDP_PUBLISHED', 'tbl.published'); ?>
				</th>
				<th width="2%">
					<?php echo $this->searchToolsSort('HDP_ID', 'tbl.id'); ?>
				</th>
			</tr>
			</thead>
			<tfoot>
			<tr>
				<td colspan="7">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
			</tfoot>
            <tbody <?php if ($this->saveOrder) :?> class="js-draggable" data-url="<?php echo $this->saveOrderingUrl; ?>" data-direction="<?php echo strtolower($this->state->filter_order_Dir); ?>" data-nested="false"<?php endif; ?>>
			<?php
			$k             = 0;
			$categoryTypes = [
				0 => Text::_('HDP_BOTH'),
				1 => Text::_('HDP_TICKETS'),
				2 => Text::_('HDP_KNOWLEDGE_BASE'),
			];
			for ($i = 0, $n = count($this->items); $i < $n; $i++)
			{
				$row       = $this->items[$i];
				$link      = $this->getEditItemLink($row);
				$checked   = HTMLHelper::_('grid.id', $i, $row->id);
				$published = HTMLHelper::_('jgrid.published', $row->published, $i);

				// Get the parents of item for sorting
				if ($row->level > 1)
				{
					$parentsStr = '';
					$_currentParentId = $row->parent_id;
					$parentsStr = ' ' . $_currentParentId;
					for ($i2 = 0; $i2 < $row->level; $i2++)
					{
						foreach ($this->ordering as $k => $v)
						{
							$v = implode('-', $v);
							$v = '-' . $v . '-';
							if (strpos($v, '-' . $_currentParentId . '-') !== false)
							{
								$parentsStr .= ' ' . $k;
								$_currentParentId = $k;
								break;
							}
						}
					}
				}
				else
				{
					$parentsStr = '';
				}
                ?>
				<tr class="row<?php echo $i % 2; ?>" data-draggable-group="<?php echo $row->parent_id; ?>" item-id="<?php echo $row->id ?>" parents="<?php echo $parentsStr ?>" level="<?php echo $row->level ?>">
					<td class="order nowrap center hidden-phone">
						<?php $this->reOrderCell($row); ?>
					</td>
					<td>
						<?php echo $checked; ?>
					</td>
					<td>
						<a href="<?php echo $link; ?>">
							<?php echo $row->treename; ?>
						</a>
					</td>
					<td>
						<?php echo $categoryTypes[$row->category_type]; ?>
					</td>
					<td class="center">
						<?php echo $row->total_tickets; ?>
					</td>
					<td class="center">
						<?php echo $published; ?>
					</td>
					<td class="center">
						<?php echo $row->id; ?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
		</table>
	</div>
	<?php $this->renderFormHiddenVariables(); ?>
</form>