<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Article;

use OSL\View\ItemView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

defined('_JEXEC') or die;

class Html extends ItemView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		$rows = HelpdeskProHelperDatabase::getAllCategories('title', [], '', 2);

		$this->lists['category_id'] = HelpdeskProHelperHtml::buildCategoryDropdown(
			$this->item->category_id,
			'category_id',
			'class="input-large form-select"',
			$rows
		);
	}
}