<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

/**
 * Pre-defined reply table class
 *
 * @property $id
 * @property $title
 * @property $message
 */
class Reply extends Table
{

	/**
	 * Constructor
	 *
	 * @param   DatabaseDriver  $db  The connector object
	 *
	 * @since 1.5
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__helpdeskpro_replies', 'id', $db);
	}
}