<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use Joomla\Database\DatabaseQuery;
use OSL\Model\ListModel;

defined('_JEXEC') or die;

class Fields extends ListModel
{
	/**
	 * Initialize the model, add new states
	 */
	protected function initialize()
	{
		$this->state->insert('filter_category_id', 'int', 0);
	}

	/**
	 * Build the query object which is used to get list of records from database
	 *
	 * @return DatabaseQuery
	 */
	protected function buildListQuery()
	{
		$query = parent::buildListQuery();

		if ($this->state->filter_category_id > 0)
		{
			$query->where(
				'(tbl.category_id=-1 OR tbl.id IN (SELECT field_id FROM #__helpdeskpro_field_categories WHERE category_id=' . (int) $this->state->filter_category_id . '))'
			);
		}

		return $query;
	}
}