<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use Joomla\Database\DatabaseQuery;
use OSL\Container\Container;
use OSL\Model\ListModel;

defined('_JEXEC') or die;

class EmailLogs extends ListModel
{
	/**
	 * Constructor
	 *
	 * @param   Container  $container
	 * @param   array      $config
	 */
	public function __construct(Container $container, $config = [])
	{
		parent::__construct($container, $config);

		$this->state->insert('filter_email_type', 'string', '')
			->insert('filter_sent_to', 'int', 0)
			->setDefault('filter_order_Dir', 'DESC');
	}

	/**
	 * Build List Query
	 *
	 * @return DatabaseQuery
	 */
	protected function buildListQuery()
	{
		$query = parent::buildListQuery();

		$db = $this->getDbo();

		if ($this->state->filter_email_type)
		{
			$query->where('tbl.email_type = ' . $db->quote($this->state->filter_email_type));
		}

		if ($this->state->filter_sent_to)
		{
			$query->where('tbl.sent_to = ' . $this->state->filter_sent_to);
		}

		return $query;
	}
}