<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use Joomla\CMS\Factory;
use OSL\Container\Container;
use OSL\Model\Model;

defined('_JEXEC') or die;

class Dashboard extends Model
{
	/**
	 * Get number categories
	 *
	 * @return int
	 */
	public function getNumberCategories(): int
	{
		$db    = $this->getDbo();
		$query = $db->getQuery(true)
			->select("COUNT(*)")
			->from('#__helpdeskpro_categories');
		$db->setQuery($query);

		return (int) $db->loadResult();
	}

	/**
	 * Get number of tickets from given duration
	 *
	 * @param   string  $fromDate
	 * @param   string  $toDate
	 * @param   int     $statusId
	 *
	 * @return int
	 */
	public function getNumberTicketsFromDuration($fromDate = null, $toDate = null, $statusId = null): int
	{
		$db    = $this->getDbo();
		$query = $db->getQuery(true)
			->select("COUNT(*)")
			->from('#__helpdeskpro_tickets');

		if ($fromDate)
		{
			$query->where('created_date >= ' . $db->quote($fromDate));
		}

		if ($toDate)
		{
			$query->where('created_date <=' . $db->quote($toDate));
		}

		if ($statusId !== null)
		{
			$query->where('status_id = ' . (int) $statusId);
		}

		$db->setQuery($query);

		return (int) $db->loadResult();
	}

	/**
	 * Get number comments from duration
	 *
	 * @param   string  $fromDate
	 * @param   string  $toDate
	 *
	 * @return int
	 */
	public function getNumberCommentsFromDuration($fromDate = null, $toDate = null): int
	{
		$db    = $this->getDbo();
		$query = $db->getQuery(true)
			->select("COUNT(*)")
			->from('#__helpdeskpro_messages');

		if ($fromDate)
		{
			$query->where('date_added >= ' . $db->quote($fromDate));
		}

		if ($toDate)
		{
			$query->where('date_added <=' . $db->quote($toDate));
		}

		$db->setQuery($query);

		return (int) $db->loadResult();
	}

	/**
	 * Get tickets chart data
	 *
	 * @return array
	 */
	public function getTicketsChartData(): array
	{
		$today = Factory::getDate('now', Factory::getApplication()->get('offset'));

		// Start with the first day of month
		$today->setDate($today->format('Y', true), $today->format('n', true), 1);

		$data = [];

		for ($i = 0; $i < 13; $i++)
		{
			if ($i > 0)
			{
				$today->modify('-1 month');
			}

			$month = $today->format('n', true);
			$year  = $today->format('Y', true);

			$startMonth = clone $today;
			$endMonth   = clone $today;

			$startMonth->setTime(0, 0, 0);
			$startMonth->setDate($year, $month, 1);
			$endMonth->setTime(23, 59, 59);
			$endMonth->setDate($year, $month, $today->format('t', true));

			$data[$today->format('M') . '/ ' . $year] = $this->getNumberTicketsFromDuration(
				$startMonth->toSql(),
				$endMonth->toSql()
			);
		}

		return $data;
	}

	/**
	 * Get latest updated tickets
	 *
	 * @return array
	 * @throws \Exception
	 */
	public function getLatestTickets(): array
	{
		// Get component config data
		$config = require JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/config.php';

		// Creating component container
		$container = Container::getInstance('com_helpdeskpro', $config);

		/* @var Tickets $model */
		$model = $container->factory->createModel(
			'Tickets',
			['ignore_request' => true, 'remember_states' => false],
			'admin'
		);

		$model->setState('limit', 8);

		return $model->getData();
	}
}