<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use Joomla\CMS\Factory;
use OSL\Container\Container;
use OSL\Model\Model;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

// no direct access
defined('_JEXEC') or die;

class Activities extends Model
{

	private $users;

	/**
	 * Constructor
	 *
	 * @param   Container  $container
	 * @param   array      $config
	 */
	public function __construct(Container $container, $config = [])
	{
		$config['table'] = '#__helpdeskpro_tickets';

		parent::__construct($container, $config);

		$date = Factory::getDate('now', Factory::getApplication()->get('offset'));

		$this->state->insert('filter_user_id', 'int', 0)
			->insert('filter_start_date', 'string', $date->format('Y-m-d', true))
			->insert('filter_end_date', 'string', $date->format('Y-m-d', true));
	}

	/**
	 * Get activities data
	 *
	 * @return array
	 */
	public function getData()
	{
		$offset    = Factory::getApplication()->get('offset');
		$startDate = Factory::getDate($this->state->filter_start_date . ' 00:00:00', $offset);
		$endDate   = Factory::getDate($this->state->filter_end_date . ' 23:59:59', $offset);

		$db    = $this->getDbo();
		$query = $db->getQuery(true)
			->select('tbl.*, c.title AS category_title')
			->from('#__helpdeskpro_messages AS tbl')
			->innerJoin('#__helpdeskpro_tickets as t ON tbl.ticket_id = t.id')
			->innerJoin('#__helpdeskpro_categories as c ON t.category_id = c.id')
			->where('tbl.date_added >= ' . $db->quote($startDate->toSql()))
			->where('tbl.date_added <= ' . $db->quote($endDate->toSql()));

		if ($this->state->filter_user_id)
		{
			$query->where('tbl.user_id = ' . $this->state->filter_user_id);
		}
		else
		{
			$users = $this->getUsers();

			$userIds = [];

			foreach ($users as $user)
			{
				$userIds[] = $user->id;
			}

			$query->whereIn('tbl.user_id', $userIds);
		}

		$query->order('tbl.id DESC');
		$db->setQuery($query);

		return $db->loadObjectList();
	}

	/**
	 * Get list of users used in the activities report
	 *
	 * @return array
	 */
	public function getUsers()
	{
		if (empty($this->users))
		{
			$db    = $this->getDbo();
			$query = $db->getQuery(true);

			$categories = HelpdeskProHelperDatabase::getAllCategories();

			//List of staffs
			$staffs = HelpdeskProHelperDatabase::getAllStaffs(
				(int) HelpdeskProHelper::getConfigValue('staff_group_id')
			);

			//Get list of managers
			$managers = [];

			foreach ($categories as $category)
			{
				if ($category->managers)
				{
					$managers = array_merge($managers, explode(',', trim($category->managers)));
				}
			}

			$managers = array_unique($managers);

			$query->select('id')
				->from('#__users AS a')
				->innerJoin('#__user_usergroup_map AS b ON a.id = b.user_id ')
				->whereIn('b.group_id', [7, 8]);
			$db->setQuery($query);
			$superAdminIds = $db->loadColumn();

			$query->clear()
				->select('id, username')
				->from('#__users')
				->where(
					'username IN ("' . implode('","', $managers) . '") OR id IN (' . implode(
						',',
						$superAdminIds
					) . ')'
				);
			$db->setQuery($query);

			$this->users = array_merge($staffs, $db->loadObjectList());
		}

		return $this->users;
	}
}