<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseDriver;
use Joomla\Filesystem\File;

class Tool extends Controller
{
	public function delete_old_attachments()
	{
		$year  = $this->input->getInt('year', date('Y') - 3);
		$db    = $this->container->db;
		$query = $db->getQuery(true)
			->select('attachments')
			->from('#__helpdeskpro_tickets')
			->where('attachments != ""')
			->where('YEAR(created_date) <= ' . $year);
		$db->setQuery($query);
		$messages = $db->loadObjectList();

		$path  = JPATH_ROOT . '/media/com_helpdeskpro/attachments/';
		$count = 0;

		foreach ($messages as $message)
		{
			if ($message->attachments)
			{
				$files = explode('|', $message->attachments);

				foreach ($files as $file)
				{
					if (empty($file))
					{
						continue;
					}

					$filePath = $path . $file;

					if (file_exists($filePath))
					{
						$count++;
						File::delete($filePath);
					}
				}
			}
		}

		// Query messages

		$query->clear()
			->select('attachments')
			->from('#__helpdeskpro_messages')
			->where('attachments != ""')
			->where('YEAR(date_added) <= ' . $year);
		$db->setQuery($query);
		$messages = $db->loadObjectList();

		foreach ($messages as $message)
		{
			if ($message->attachments)
			{
				$files = explode('|', $message->attachments);

				foreach ($files as $file)
				{
					if (empty($file))
					{
						continue;
					}

					$filePath = $path . $file;

					if (file_exists($filePath))
					{
						$count++;
						File::delete($filePath);
					}
				}
			}
		}

		echo 'Total Files Deleted:' . $count;
	}

	/**
	 * Tool to convert important tables to use utf8mb4
	 *
	 * @return void
	 */
	public function convert_to_utf8mb4()
	{
		/* @var DatabaseDriver $db */
		$db = Factory::getContainer()->get('db');

		$tablesToConvert = [
			'#__helpdeskpro_categories',
			'#__helpdeskpro_tickets',
			'#__helpdeskpro_messages',
			'#__helpdeskpro_articles',
			'#__helpdeskpro_replies',
		];

		foreach ($tablesToConvert as $table)
		{
			// Convert table
			$sql = "ALTER TABLE $table CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";
			$db->setQuery($sql)
				->execute();
		}
	}
}