<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Controller;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

class Language extends Controller
{
	public function save()
	{
		/* @var \OSSolution\HelpdeskPro\Admin\Model\Language $model */
		$model = $this->getModel();
		$data  = $this->input->getData();
		$model->store($data);

		$lang = $data['filter_language'];
		$url  = Route::_(
			'index.php?option=com_helpdeskpro&view=language&lang=' . $lang . '&item=com_helpdeskpro',
			false
		);

		$this->setRedirect($url, Text::_('Translation saved'));
	}

	/**
	 * Cancel editing email messages. Redirect user to tickets list page
	 *
	 */
	public function cancel()
	{
		$this->setRedirect('index.php?option=com_helpdeskpro&view=tickets');
	}
}