<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Controller;

use Exception;
use Joomla\CMS\Language\Text;
use OSL\Input\Input;

defined('_JEXEC') or die;

class Email extends Controller
{
	/**
	 * Save the Configuration
	 *
	 */
	public function save()
	{
		$post = $this->input->post->getData(Input::INPUT_ALLOWRAW);

		unset($post['option'], $post['task']);

		/* @var \OSSolution\HelpdeskPro\Admin\Model\Email $model */
		$model = $this->getModel();

		try
		{
			$model->store($post);
			$msg = Text::_('HDP_EMAIL_MESSAGE_SAVED');
		}
		catch (Exception $e)
		{
			$msg = Text::_('HDP_EMAIL_MESSAGE_SAVING_ERROR');
		}

		if ($this->getTask() == 'apply')
		{
			$this->setRedirect('index.php?option=com_helpdeskpro&view=email', $msg);
		}
		else
		{
			$this->setRedirect('index.php?option=com_helpdeskpro&view=tickets', $msg);
		}
	}

	/**
	 * Cancel editing email messages. Redirect user to tickets list page
	 *
	 */
	public function cancel()
	{
		$this->setRedirect('index.php?option=com_helpdeskpro&view=tickets');
	}
}