<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Controller;

use com_helpdeskproInstallerScript;
use Exception;
use Joomla\CMS\Factory;
use Joomla\Database\DatabaseDriver;
use OSL\Controller\AdminController as AdminController;
use OSSolution\HelpdeskPro\Admin\Model\Dashboard;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Menu as HelpdeskProMenuHelper;

defined('_JEXEC') or die;

class Controller extends AdminController
{
	/**
	 * Display information
	 *
	 */
	public function display($cachable = false, array $urlparams = [])
	{
		$wa = $this->app->getDocument()
			->getWebAssetManager();

		$assetVersion = HelpdeskProHelper::getInstalledVersion();
		$isAdminApp   = $this->app->isClient('administrator');

		if ($isAdminApp)
		{
			$wa->registerAndUseStyle(
				'com_helpdeskpro.style',
				'media/com_helpdeskpro/admin/assets/css/style.min.css',
				['version' => $assetVersion]
			);
		}
		else
		{
			$config = HelpdeskProHelper::getConfig();

			if ($config->load_twttier_bootstrap_framework_in_frontend !== '0')
			{
				$wa->useStyle('bootstrap.css');
			}

			$wa->registerAndUseStyle(
				'com_helpdeskpro.style',
				'media/com_helpdeskpro/assets/css/style.min.css',
				['version' => $assetVersion]
			);
		}

		$wa->registerAndUseStyle(
			'com_helpdeskpro.common',
			'media/com_helpdeskpro/assets/css/common.min.css',
			['version' => $assetVersion]
		)
			->registerAndUseStyle(
				'com_helpdeskpro.dropzone.basic',
				'media/com_helpdeskpro/assets/dropzone/basic.min.css',
				['version' => $assetVersion]
			)
			->registerAndUseStyle(
				'com_helpdeskpro.dropzone.dropzone',
				'media/com_helpdeskpro/assets/dropzone/dropzone.min.css',
				['version' => $assetVersion]
			);


		$customCssFile = JPATH_ROOT . '/media/com_helpdeskpro/assets/css/custom.css';

		if (file_exists($customCssFile) && filesize($customCssFile))
		{
			$wa->registerAndUseStyle(
				'com_helpdeskpro.custom',
				'media/com_helpdeskpro/assets/css/custom.css',
				['version' => filemtime($customCssFile)]
			);
		}

		$wa->useScript('core')
			->useScript('jquery')
			->useScript('jquery-noconflict')
			->registerAndUseScript(
				'com_helpdeskpro.helpdeskpro',
				'media/com_helpdeskpro/assets/js/helpdeskpro.min.js',
				['version' => $assetVersion]
			)
			->registerAndUseScript(
				'com_helpdeskpro.dropzone',
				'media/com_helpdeskpro/assets/dropzone/dropzone.min.js',
				['version' => $assetVersion]
			);


		$view = $this->input->getCmd('view', 'dashboard');

		if (in_array($view, [
			'dashboard',
			'configuration',
			'categories',
			'tickets',
			'articles',
			'report',
			'activities',
			'fields',
			'email',
			'statuses',
			'priorities',
			'labels',
			'replies',
			'language',
			'emaillogs',
		]))
		{
			HelpdeskProMenuHelper::renderSubmenu($view);
		}

		parent::display($cachable, $urlparams);

		if ($isAdminApp && $this->input->getCmd('format', 'html') != 'raw')
		{
			HelpdeskProHelper::displayCopyRight();
		}
	}

	/**
	 * Method to make a custom field search and sortable
	 *
	 */
	public function make_field_search_sort_able()
	{
		$fieldId = $this->input->getInt('field_id');

		/* @var DatabaseDriver $db */
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('*')
			->from('#__helpdeskpro_fields')
			->where('id = ' . (int) $fieldId);
		$db->setQuery($query);
		$field = $db->loadObject();

		if (!$field)
		{
			throw new Exception('The field does not exist');
		}

		// Add new field to #__eb_registrants
		$fields = array_keys($db->getTableColumns('#__helpdeskpro_tickets'));

		if (!in_array($field->name, $fields))
		{
			$sql = "ALTER TABLE  `#__helpdeskpro_tickets` ADD  `$field->name` VARCHAR( 255 ) NULL;";
			$db->setQuery($sql)
				->execute();

			$query->clear()
				->select('*')
				->from('#__helpdeskpro_field_value')
				->where('field_id = ' . $fieldId);
			$db->setQuery($query);
			$rows = $db->loadObjectList();

			$fieldName = $db->quoteName($field->name);

			foreach ($rows as $row)
			{
				$query->clear()
					->update('#__helpdeskpro_tickets')
					->set($fieldName . ' = ' . $db->quote($row->field_value))
					->where('id = ' . $row->ticket_id);
				$db->setQuery($query);
				$db->execute();
			}
		}

		// Mark the field as searchable
		$query->clear()
			->update('#__helpdeskpro_fields')
			->set('is_searchable = 1')
			->where('id = ' . (int) $fieldId);
		$db->setQuery($query);
		$db->execute();

		echo sprintf('Field %s is not searchable in Tickets Management', $fieldId);
	}

	/**
	 * Upgrade database schema
	 */
	public function upgrade()
	{
		require_once JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/script.helpdeskpro.php';

		com_helpdeskproInstallerScript::updateDatabaseSchema();
	}

	/**
	 * Get statistic data for duration
	 *
	 * @return void
	 * @throws Exception
	 */
	public function get_statistic_for_duration()
	{
		$config   = HelpdeskProHelper::getConfig();
		$duration = $this->input->getString('statistic_duration', 'all');

		/* @var Dashboard $model */
		$model = $this->getModel('dashboard');

		[$fromDate, $toDate] = HelpdeskProHelper::getDateDuration($duration);

		$totalNumberTickets  = $model->getNumberTicketsFromDuration($fromDate, $toDate);
		$totalClosedTickets  = $model->getNumberTicketsFromDuration(
			$fromDate,
			$toDate,
			(int) $config->closed_ticket_status
		);
		$totalNumberComments = $model->getNumberCommentsFromDuration($fromDate, $toDate);

		$response = [
			'totalNumberTickets'  => $totalNumberTickets . '+',
			'totalClosedTickets'  => $totalClosedTickets . '+',
			'totalNumberComments' => $totalNumberComments . '+',
		];

		echo json_encode($response);

		$this->app->close();
	}
} 