<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Controller;

use Exception;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

class Configuration extends Controller
{
	/**
	 * Save the Configuration
	 *
	 */
	public function save()
	{
		$post = $this->input->post->getData();

		unset($post['option'], $post['task']);

		/* @var \OSSolution\HelpdeskPro\Admin\Model\Configuration $model */
		$model = $this->getModel('configuration');

		try
		{
			$model->store($post);
			$msg = Text::_('HDP_CONFIGURATION_SAVED');
		}
		catch (Exception $e)
		{
			$msg = Text::_('HDP_CONFIGURATION_SAVING_ERROR');
		}

		if ($this->getTask() == 'apply')
		{
			$this->setRedirect('index.php?option=com_helpdeskpro&view=configuration', $msg);
		}
		else
		{
			$this->setRedirect('index.php?option=com_helpdeskpro&view=tickets', $msg);
		}
	}

	/**
	 * Cancel the configuration . Redirect user to pictures list page
	 *
	 */
	public function cancel()
	{
		$this->setRedirect('index.php?option=com_helpdeskpro&view=tickets');
	}
}