<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

$model = new ChronoModel();
if (ChronoApp::$instance->isPost) {
	if(empty($this->data("name"))){
		ChronoSession::setFlash("error", "Table name is missing");
		ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables.new");
	}

	if(empty($this->data("field"))){
		ChronoSession::setFlash("error", "No fields have been added");
		// ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables.new");
	}

	// Chrono::pr(ChronoApp::$instance->data);

	$sql = "CREATE TABLE IF NOT EXISTS `" .$this->data("name"). "` (";


	foreach($this->data("field")["name"] as $k => $name){
		$sql .= "`" .$name. "` " .$this->data("field")["type"][$k];
		if(!empty($this->data("field")["length"][$k])){
			$sql .= "(" .$this->data("field")["length"][$k].")";
		}
		$sql .= ",";
	}

	$sql = trim($sql, ",");

	$sql .= "  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

	$result = $model->Execute($sql);

	// Chrono::pr($sql);
	if ($result === true) {
		ChronoSession::setFlash("success", Chrono::l("Table created successfully."));
		ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.structure&table=".$this->data("name"));
	}else{
		ChronoSession::setFlash("error", Chrono::l("Error creating table"));
	}
}
?>

<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
	<?php
	new MenuBar(title: "Create Table", buttons: [
		new MenuButton(name: "save", title: "Save", icon: "floppy-disk", color: "blue"),
		new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.tables"),
	]);

	new FormField(name: "name", label: "Table Name", code: 'data-validations=\'{"rules":[{"type":"required","prompt":"Table name is required."}]}\'');
	?>
	<?php foreach(["n" => ""] as $k => $lang): ?>
		<div class="nui form clonable fields" data-selector=".clonable.fields" data-cloner=".fields-cloner" data-key="<?php echo $k; ?>">
			<div class="equal fields">
			<?php
				new FormField(name: "field[name][".$k."]", label: "Name", code: 'data-validations=\'{"rules":[{"type":"required","prompt":"Field name is required."}]}\'');
				new FormField(name: "field[type][".$k."]", type:"select", label: "Type", options:[
					new Option(value:"int", text:"INT"),
					new Option(value:"tinyint", text:"TINYINT"),
					new Option(value:"smallint", text:"SMALLINT"),
					new Option(value:"mediumint", text:"MEDIUMINT"),
					new Option(value:"bigint", text:"BIGINT"),
					new Option(value:"decimal", text:"Decimal"),
					new Option(value:"float", text:"Float"),
					new Option(value:"char", text:"Char"),
					new Option(value:"varchar", text:"VARCHAR"),
					new Option(value:"text", text:"TEXT"),
					new Option(value:"tinytext", text:"TINYTEXT"),
					new Option(value:"longtext", text:"LONGTEXT"),
					new Option(value:"datetime", text:"DATETIME"),
					new Option(value:"date", text:"DATE"),
				]);
				new FormField(name: "field[length][".$k."]", label: "Length");
			?>
			<button type="button" class="nui button red self-center remove-clone"><?php echo Chrono::ShowIcon("xmark"); ?></button>
			</div>
			<div class="nui divider block"></div>
		</div>
	<?php endforeach; ?>
	<button type="button" class="nui button blue iconed fields-cloner"><?php echo Chrono::ShowIcon("plus"); ?>Add Field</button>
</form>