<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

$tcolumns = ExtensionsModel::instance()->Select(sql: "SHOW FULL COLUMNS FROM ".$this->data("table"));

$indexes = ExtensionsModel::instance()->Select(sql: "SHOW INDEX FROM ".$this->data("table"));
// Chrono::pr($indexes);
$tindexes = [];
foreach($indexes as $index){
	$index["Columns"] = (array)$index["Column_name"];
	if(isset($tindexes[$index["Key_name"]])){
		$index["Columns"] = array_merge($index["Columns"], (array)$tindexes[$index["Key_name"]]["Columns"]);
	}
	$tindexes[$index["Key_name"]] = $index;
}

// Chrono::pr($tindexes);

$pkeys = [];
foreach($tcolumns as $tcolumn){
	if($tcolumn["Key"] == "PRI"){
		$pkeys[] = $tcolumn["Field"];
	}
}

require(__DIR__."/ma.menubar.php");

new DataTable($tcolumns, [
	new TableColumn(name:"_Edit", title:"", func:function($row){
		return '<a class="nui label blue rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.field.edit&table=".$this->data("table")."&field=".$row["Field"].'">Edit</a>'.
		'&nbsp;<a class="nui label red rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.field.delete&table=".$this->data("table")."&field=".$row["Field"].'">Delete</a>';
	}),
	new TableColumn(name:"Field", title:"Name", expand:true, func:function($row){
		return '<strong>'.$row["Field"].'</strong>';
	}),
	new TableColumn(name:"Type", title:"Type"),
	new TableColumn(name:"Collation", title:"Collation", func:function($row){
		return (!is_null($row["Collation"])) ? $row["Collation"] : "";
	}),
	new TableColumn(name:"Null", title:"Null", func:function($row){
		return ($row["Null"] != "YES") ? Chrono::ShowIcon("xmark nui red") : Chrono::ShowIcon("check nui green");
	}),
	new TableColumn(name:"Default", title:"Default", func:function($row){
		return (!is_null($row["Default"])) ? $row["Default"] : '<em>None</em>';
	}),
	new TableColumn(name:"Extra", title:"Extra"),
]);

new DataTable($tindexes, [
	new TableColumn(name:"_Edit", title:"", func:function($row){
		return '<a class="nui label red rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.index.delete&table=".$this->data("table")."&index=".$row["Key_name"].'">Delete</a>';
	}),
	new TableColumn(name:"Key_name", title:"Name", expand:true, func:function($row){
		return '<strong>'.$row["Key_name"].'</strong>';
	}),
	new TableColumn(name:"Columns", title:"Columns", func:function($row){
		return implode(", ", $row["Columns"]);
	}),
	new TableColumn(name:"Type", title:"Type", func:function($row){
		if(!empty($row["Non_unique"])){
			return "Index";
		}else{
			if($row["Key_name"] == "PRIMARY"){
				return "PRIMARY";
			}
			return "Unique";
		}
	}),
]);
?>