<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

if (ChronoApp::$instance->isPost) {
	if(isset($_POST["rename"]) && !empty($this->data("table_rename"))){
		$sql = "RENAME TABLE `".$this->data("table")."` TO `".$this->data("table_rename")."`";
		
		$result = $model->Execute($sql);
	
		if ($result === true) {
			ChronoSession::setFlash("success", Chrono::l("Table renamed successfully."));
			ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.operations&table=".$this->data("table_rename"));
		}else{
			ChronoSession::setFlash("error", Chrono::l("Error updating table"));
		}
	}else if(isset($_POST["save_collate"])){
		$sql = "ALTER TABLE  `".$this->data("table")."` COLLATE `".$this->data("table_collate")."`";
		
		$result = $model->Execute($sql);
	
		if ($result === true) {
			ChronoSession::setFlash("success", Chrono::l("Table collation updated successfully."));
			ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.operations&table=".$this->data("table"));
		}else{
			ChronoSession::setFlash("error", Chrono::l("Error updating table"));
		}
	}
}
?>

<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
<?php
require(__DIR__."/ma.menubar.php");
?>
<div class="nui flex wrap spaced equal items">
	<div class="nui segment white rounded bordered item">
		<?php new FormField(name: "table_rename", label: "Rename table to", value:$this->data("table")); ?>
		<button type="submit" name="rename" label="Rename" class="nui button green iconed block"><?php echo Chrono::ShowIcon("check"); ?>Rename</button>
	</div>
	<div class="nui segment white rounded bordered item">
		<?php new FormField(name: "table_collate", label: "Change table collation"); ?>
		<button type="submit" name="save_collate" label="Rename" class="nui button green iconed block"><?php echo Chrono::ShowIcon("check"); ?>Update Collation</button>
	</div>
</div>

<div class="nui flex block equal items spaced">
	<div class="item">
		<a class="nui button green full width iconed" href="<?php echo ChronoApp::$instance->extension_url."&action=ma.optimize&table=".$this->data("table"); ?>"><?php echo Chrono::ShowIcon("check"); ?>Optimize Table</a>
	</div>
	<div class="item">
		<a class="nui button blue full width iconed" href="<?php echo ChronoApp::$instance->extension_url."&action=ma.export&table=".$this->data("table"); ?>"><?php echo Chrono::ShowIcon("floppy-disk"); ?>Export Table</a>
	</div>
	<div class="item">
		<a class="nui button orange full width iconed" href="<?php echo ChronoApp::$instance->extension_url."&action=ma.truncate&table=".$this->data("table"); ?>"><?php echo Chrono::ShowIcon("trash"); ?>Truncate Table</a>
	</div>
	<div class="item">
		<a class="nui button red full width iconed" href="<?php echo ChronoApp::$instance->extension_url."&action=ma.drop&table=".$this->data("table"); ?>"><?php echo Chrono::ShowIcon("xmark"); ?>Drop Table</a>
	</div>
</div>
</form>