<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

if (ChronoApp::$instance->isPost) {
	$kname = "";
	if(!empty($this->data("type"))){
		$kname = " `".$this->data("name")."` ";
	}
	$sql = "ALTER TABLE `".$this->data("table")."`" . " ADD " . $this->data("type") . $kname . "(`" . implode("`,`", $this->data("columns")) . "`)" . ";";

	$result = $model->Execute($sql);

	// Chrono::pr($sql);
	if ($result === true) {
		ChronoSession::setFlash("success", Chrono::l("Table updated successfully."));
		ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.structure&table=".$this->data("table"));
	}else{
		ChronoSession::setFlash("error", Chrono::l("Error updating table"));
	}
}

$tcolumns = $model->Select(sql: "SHOW FULL COLUMNS FROM ".$this->data("table"));

$columns_options = [];

foreach($tcolumns as $tcolumn){
	$columns_options[] = new Option(value:$tcolumn["Field"], text:$tcolumn["Field"]);
}
?>
<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
	<?php
	require(__DIR__."/ma.menubar.php");
	?>
	<div class="equal fields">
		<?php new FormField(name: "name", label: "Name"); ?>
		<?php new FormField(name: "type", type:"select", label: "Type", options:[
			new Option(value:"INDEX", text:"Index"),
			new Option(value:"UNIQUE", text:"Unique"),
			new Option(value:"Primary Key", text:"Primary"),
		]); ?>
		<?php new FormField(name: "columns", type:"select", label: "Columns", multiple:true, options:$columns_options); ?>
	</div>
</form>
<div class="equal fields">
	<Field name="name" label="Name"></Field>
	<Field name="type" label="Type" type="select" options="{INDEX=Index}{UNIQUE=Unique}{=Primary}"></Field>
	<Field name="columns" label="Columns" type="select" multiple="multiple"></Field>
</div>