<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

if (ChronoApp::$instance->isPost) {
	$sql = "ALTER TABLE `".$this->data("table")."`";
	if(!empty($this->data("field"))){
		$sql .= " CHANGE `".$this->data("field")."` ";
	}else{
		$sql .= " ADD ";
	}

	$pcs = [];
	if(!empty($this->data("Field"))){
		$pcs[] = "`".$this->data("Field")."`";
	}
	if(!empty($this->data("length"))){
		$pcs[] = $this->data("type")."(".$this->data("length").")";
	}else{
		$pcs[] = $this->data("type");
	}

	$pcs[] = $this->data("attr");
	$pcs[] = $this->data("Extra");
	$pcs[] = ($this->data("Null") == "NO") ? "NOT NULL" : "NULL";
	if(isset(ChronoApp::$instance->DataArray()["Default"])){
		$pcs[] = "DEFAULT '".$this->data("Default")."'";
	}
	if(!empty($this->data("Collation"))){
		$pcs[] = "COLLATE ".$this->data("Collation");
	}
	if(!empty($this->data("position"))){
		if($this->data("position") == "*"){
			$pcs[] = "FIRST";
		}else{
			$pcs[] = "after `".$this->data("position")."`";
		}
	}
	
	$sql .= implode(" ", $pcs);

	$result = $model->Execute($sql);

	// Chrono::pr($sql);
	if ($result === true) {
		ChronoSession::setFlash("success", Chrono::l("Table updated successfully."));
		ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.structure&table=".$this->data("table"));
	}else{
		ChronoSession::setFlash("error", Chrono::l("Error updating table"));
	}
}

$tcolumns = $model->Select(sql: "SHOW FULL COLUMNS FROM ".$this->data("table"));
if(!empty($this->data("field"))){
	foreach($tcolumns as $tcolumn){
		if($tcolumn["Field"] == $this->data("field")){
			// Chrono::pr($tcolumn);
			ChronoApp::$instance->MergeData($tcolumn);
			$tpcs = explode("(", $tcolumn["Type"]);
			ChronoApp::$instance->data["type"] = $tpcs[0];
			if(count($tpcs) > 1){
				ChronoApp::$instance->data["length"] = explode(")", $tpcs[1])[0];
				if(count(explode(")", $tpcs[1])) > 1){
					ChronoApp::$instance->data["attr"] = trim(explode(")", $tpcs[1])[1]);
				}
			}
			break;
		}
	}
}

$position_options = [
	new Option(value:"", text:"--Last--"),
	new Option(value:"*", text:"--First--"),
];

foreach($tcolumns as $tcolumn){
	$position_options[] = new Option(value:$tcolumn["Field"], text:$tcolumn["Field"]);
}
?>
<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
	<?php
	require(__DIR__."/ma.menubar.php");
	?>
	<div class="equal fields">
		<?php new FormField(name: "Field", label: "Name"); ?>
		<?php new FormField(name: "type", type:"select", label: "Type", options:[
			new Option(value:"int", text:"INT"),
			new Option(value:"tinyint", text:"TINYINT"),
			new Option(value:"smallint", text:"SMALLINT"),
			new Option(value:"mediumint", text:"MEDIUMINT"),
			new Option(value:"bigint", text:"BIGINT"),
			new Option(value:"decimal", text:"Decimal"),
			new Option(value:"float", text:"Float"),
			new Option(value:"char", text:"Char"),
			new Option(value:"varchar", text:"VARCHAR"),
			new Option(value:"text", text:"TEXT"),
			new Option(value:"tinytext", text:"TINYTEXT"),
			new Option(value:"longtext", text:"LONGTEXT"),
			new Option(value:"datetime", text:"DATETIME"),
			new Option(value:"date", text:"DATE"),
		]); ?>
		<?php new FormField(name: "length", label: "Length"); ?>
		<?php new FormField(name: "attr", type:"select", label: "Attributes", options:[
			new Option(value:"", text:""),
			new Option(value:"unsigned", text:"UNSIGNED"),
			new Option(value:"unsigned zerofill", text:"UNSIGNED ZEROFILL"),
			new Option(value:"binary", text:"BINARY"),
			new Option(value:"on update CURRENT_TIMESTAMP", text:"on update CURRENT_TIMESTAMP"),
		]); ?>
	</div>
	<div class="equal fields">
		<?php new FormField(name: "Null", type:"select", label: "Null", options:[
			new Option(value:"NO", text:"NOT NULL"),
			new Option(value:"YES", text:"NULL"),
		]); ?>
		<?php new FormField(name: "Default", label: "Default Value", code:(!isset(ChronoApp::$instance->data["Default"]) || is_null(ChronoApp::$instance->data["Default"]) ? 'disabled="disabled"' : "")); ?>
		<?php new FormField(name: "nodefault", label:"No Default", type: "checkbox", value: 1, checked: !isset(ChronoApp::$instance->data["Default"]) || is_null(ChronoApp::$instance->data["Default"]), code:" onclick=\"document.getElementById('Default').toggleAttribute('disabled')\""); ?>
	</div>
	<div class="equal fields">
		<?php new FormField(name: "Extra", type:"select", label: "Auto Increment", options:[
			new Option(value:"", text:"NO"),
			new Option(value:"auto_increment", text:"Yes"),
		]); ?>
		<?php new FormField(name: "position", type:"select", label: "Position", hint: "After which column this column should be located ?", options:$position_options); ?>
		<?php new FormField(name: "Collation", label: "Collation"); ?>
	</div>
</form>