<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

$tcolumns = ExtensionsModel::instance()->Select(sql: "SHOW FULL COLUMNS FROM ".$this->data("table"));
// Chrono::pr($tcolumns);

$conditions = [];
$pkeys = [];
$tfields = [];
foreach($tcolumns as $tcolumn){
	$tfields[] = $tcolumn["Field"];
	if($tcolumn["Key"] == "PRI"){
		$conditions[] = [$tcolumn["Field"], "=", ChronoApp::$instance->data($tcolumn["Field"])];
		$pkeys[] = $tcolumn["Field"];
	}
}

if (ChronoApp::$instance->isPost) {
	if(empty($conditions) || !ChronoApp::$instance->DataExists($pkeys[0])){
		ChronoSession::setFlash("error", "You did not select any rows");
	}else{
		$model->Delete(conditions: $conditions);
		ChronoSession::setFlash("success", "row(s) deleted.");
	}
	
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.browse&table=".ChronoApp::$instance->data("table"));
}
?>

<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
<?php
require(__DIR__."/ma.menubar.php");
?>
<div class="nui segment red">
	Delete from `<?php echo ChronoApp::$instance->data("table"); ?>` WHERE 
	<?php foreach($pkeys as $pkey): ?>
		`<?php echo $pkey; ?>` = '<?php echo ChronoApp::$instance->data($pkey); ?>'
	<?php endforeach; ?>
</div>
</form>