<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

$conditions = ChronoSession::get($this->data("table")."_search", []);
if(isset($this->data["clear_search"])){
	ChronoSession::clear($this->data("table")."_search");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.browse&table=".$this->data("table"));
}

$limit = Chrono::getVal($this->settings, "browse_limit", "20");

$rows = $model->Select(conditions:$conditions, paging:true, limit:$limit, order_by:true);
$count = $model->Select(conditions:$conditions, count:true);

$tcolumns = $model->Select(sql: "SHOW FULL COLUMNS FROM ".$this->data("table"));

$pkeys = [];
foreach($tcolumns as $tcolumn){
	if($tcolumn["Key"] == "PRI"){
		$pkeys[] = $tcolumn["Field"];
	}
}

$columns = [
	new TableColumn(name:"_Edit", title:"", func:function($row) use ($pkeys){
		$keys = "";
		foreach($pkeys as $pkey){
			$keys .= "&".$pkey."=".$row[$pkey];
		}
		return '<a class="nui label blue rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.data.edit&table=".$this->data("table").($keys).'">Edit</a>'.
		'&nbsp;<a class="nui label red rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.data.delete&table=".$this->data("table").($keys).'">Delete</a>';
	}),
];
foreach($tcolumns as $tcolumn){
	$expand = false;
	$sort = true;
	$func = function($row) use($tcolumn){
		if (is_string($row[$tcolumn["Field"]])){
			$row[$tcolumn["Field"]] = htmlentities($row[$tcolumn["Field"]]);
		}
		if(!is_null($row[$tcolumn["Field"]]) && strlen($row[$tcolumn["Field"]]) > 50){
			return substr($row[$tcolumn["Field"]], 0, 50) . "...";
		}
		if(is_null($row[$tcolumn["Field"]])){
			return "<em>NULL</em>";
		}
		return $row[$tcolumn["Field"]];
	};
	$columns[] = new TableColumn(name:$tcolumn["Field"], title:$tcolumn["Field"], expand:$expand, sortable:$sort, func:$func);
}

require(__DIR__."/ma.menubar.php");

// echo '<div style="overflow-x:scroll !important; max-width:100%;">';
new DataTable($rows, $columns, count:$count, limit:$limit, wide:true);
// echo '</div>';
?>