<?php
/**
 * @package     Ardhs
 * @subpackage  com_ardhs
 *
 * @author      Abdul waheed <info@abdulwaheed.pk>
 * @website		www.abdulwaheed.pk
 * @copyright   Copyright (C) abdulwaheed.pk All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Abdul\Component\Ardhs\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Versioning\VersionableControllerTrait;
use Joomla\Input\Input;
use Joomla\Utilities\ArrayHelper;

/**
 * Controller for a single 
 *
 * @since  1.6
 */
class PropController extends FormController
{
	
	/**
     * Constructor.
     *
     * @param   array                $config   An optional associative array of configuration settings.
     * Recognized key values include 'name', 'default_task', 'model_path', and
     * 'view_path' (this list is not meant to be comprehensive).
     * @param   MVCFactoryInterface  $factory  The factory.
     * @param   CMSApplication       $app      The Application for the dispatcher
     * @param   Input                $input    Input
     *
     * @since   3.0
     */
    public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply', 	'save' );
 		$this->registerTask( 'import', 	'import' );
   }
	
	public function import(){
	
		//$jsonobj= "Acobir-20240227-EN.json";

		$filename=$_FILES['filename']["name"];
		$lang=$_POST['lang'];
		
		$tmp_name=$_FILES['filename']["tmp_name"];
		$filetype = strtolower(pathinfo($filename,PATHINFO_EXTENSION));
//		echo $filename." : ". $tmp_name." : ".$filetype;exit;
		if($filetype!=='json') {
			$this->setRedirect( 'index.php?option=com_ardhs&view=props','Only JSON file will work for importing data.');
			return false;
		}

		$arr_=json_decode(file_get_contents($tmp_name));
//echo '<pre>';print_r($arr_);exit;

		$db = Factory::getDBO();
		$i=1;
		
		foreach($arr_ as $obj){
			
		$MLSID=($lang=='en')?$obj->MLSID_EN:$obj->MLSID_ES;
		$URL=($lang=='en')?$obj->URL_EN:$obj->URL_ES;
		$TITLE=($lang=='en')?$obj->TITLE_EN:$obj->TITLE_ES;
		$MAIN_IMAGE_=($lang=='en')?$obj->MAIN_IMAGE_EN:$obj->MAIN_IMAGE_ES;
		$pathinfo_main= pathinfo($MAIN_IMAGE_);
		$MAIN_IMAGE=$pathinfo_main['filename'].'.'.$pathinfo_main['extension'];
		
		$GALLERY_IMAGES='';
		$GALLERY_IMAGES_=($lang=='en')?$obj->GALLERY_IMAGES_EN:$obj->GALLERY_IMAGES_ES;
		$GALLERY_IMAGES__='';
		$GALLERY_IMAGES_ARR=explode(",",$GALLERY_IMAGES_);
		foreach($GALLERY_IMAGES_ARR as $garr){
			$pathinfo_gall = pathinfo($garr);
		$img_=$pathinfo_gall['filename'].'.'.$pathinfo_gall['extension'];
		$GALLERY_IMAGES__.=','.$img_;
		}
		$GALLERY_IMAGES=substr($GALLERY_IMAGES__,1);
		//	echo $GALLERY_IMAGES;exit;

$NEIGHBORHOOD=($lang=='en')?$obj->NEIGHBORHOOD_EN:$obj->NEIGHBORHOOD_ES;
$DISTRICT=($lang=='en')?$obj->DISTRICT_EN:$obj->DISTRICT_ES;
$COUNTRY=($lang=='en')?$obj->COUNTRY_EN:$obj->COUNTRY_ES;
$REGION=($lang=='en')?$obj->REGION_EN:$obj->REGION_ES;
$COUNTY=($lang=='en')?$obj->COUNTY_EN:$obj->COUNTY_ES;
$DESCRIPTION=($lang=='en')?$obj->DESCRIPTION_EN:$obj->DESCRIPTION_ES;
$PROPTYPE=($lang=='en')?$obj->PROPTYPE_EN:$obj->PROPTYPE_ES;
$STATUS=($lang=='en')?$obj->STATUS_EN:$obj->STATUS_ES;
$BUILDING=($lang=='en')?$obj->BUILDING_EN:$obj->BUILDING_ES;
$PRICE=($lang=='en')?$obj->PRICE_EN:$obj->PRICE_ES;
$HOA=($lang=='en')?$obj->HOA_EN:$obj->HOA_ES;
$BUILT=($lang=='en')?$obj->BUILT_EN:$obj->BUILT_ES;
$SIZE=($lang=='en')?$obj->SIZE_EN:$obj->SIZE_ES;
$BEDROOMS=($lang=='en')?$obj->BEDROOMS_EN:$obj->BEDROOMS_ES;
$BAHTROOMS=($lang=='en')?$obj->BAHTROOMS_EN:$obj->BAHTROOMS_ES;
$PARKING=($lang=='en')?$obj->PARKING_EN:$obj->PARKING_ES;
$LOTSIZE=($lang=='en')?$obj->LOTSIZE_EN:$obj->LOTSIZE_ES;
$META_DESCRIPTION=($lang=='en')?$obj->META_DESCRIPTION_EN:$obj->META_DESCRIPTION_ES;
$META_KEY=($lang=='en')?$obj->META_KEY_EN:$obj->META_KEY_ES;
 
			if($TITLE!=""&&$MLSID!="") {
			$str_="INSERT INTO `#__ardh_properties` (
			`createdby`, 
			`mlsid`, 
			`lang`, 
			`url`, 
			`title`, 
			`contact`, 
			`main_image`, 
			`gallery_images`, 
			`neighborhood`, 
			`district`, 
			`country`, 
			`region`, 
			`county`, 
			`description`, 
			`proptype`, 
			`status`, 
			`building`, 
			`price`, 
			`hoa`, 
			`built`, 
			`size`, 
			`bedrooms`, `bathrooms`, `parking`, 
			`lotsize`, 
			`meta_description`, `meta_key`, 
			`state`, `ordering`) VALUES(0, '".str_replace("'"," ",$MLSID)."', '".str_replace("'"," ",$lang)."', 
'".str_replace("'"," ",$URL)."', 
			'".str_replace("'"," ",$TITLE)."', 
			'',
			'".$MAIN_IMAGE."',
			'".$GALLERY_IMAGES."', 
			'".str_replace("'"," ",$NEIGHBORHOOD)."', 
			'".str_replace("'"," ",$DISTRICT)."', 
			'".str_replace("'"," ",$COUNTRY)."', 
			'".str_replace("'"," ",$REGION)."', 
			'".str_replace("'"," ",$COUNTY)."', 
			'".str_replace("'"," ",$DESCRIPTION)."', 
			'".str_replace("'"," ",$PROPTYPE)."', 
			'".str_replace("'"," ",$STATUS)."', 
			'".str_replace("'"," ",$BUILDING)."', 
			'".str_replace("'"," ",$PRICE)."', 
			'".str_replace("'"," ",$HOA)."', 
			'".str_replace("'"," ",$BUILT)."', 
			'".str_replace("'"," ",$SIZE)."', 
			'".str_replace("'"," ",$BEDROOMS)."', 
			'".str_replace("'"," ",$BAHTROOMS)."', 
			'".str_replace("'"," ",$PARKING)."', 
			'".str_replace("'"," ",$LOTSIZE)."', 
			'".str_replace("'"," ",$META_DESCRIPTION)."', 
			'".str_replace("'"," ",$META_KEY)."', 
			1, 
			1);";
	//	echo "<h1>$str_</h1>";//exit;	
	//	if($i==10)  exit;
			$db->setQuery($str_);
			$result=true;$db->execute();
			$allfine=false;
			if($result) $allfine=true;
		//	echo "<h1>$i</h1>";
			$i++;
			}
		}
		
		$msg=($allfine) ? 'Data Imported Successfully.' : 'Something went wrong.';
		$this->setRedirect( 'index.php?option=com_ardhs&view=props',$msg);
	//	echo $msg;exit;
		return true;
	}
	
	public function getModel($name = 'prop', $prefix = 'Administrator', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}


	public function cancel($key = NULL)
	{
		$msg = ( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_ardhs&view=props', $msg );
	}

    /**
     * Method override to check if you can add a new record.
     *
     * @param   array  $data  An array of input data.
     *
     * @return  boolean
     *
     * @since   1.6
     */
    protected function allowAdd($data = array())
    {
        $categoryId = ArrayHelper::getValue($data, 'catid', $this->input->getInt('filter_category_id'), 'int');

        if ($categoryId) {
            // If the category has been passed in the data or URL check it.
            return $this->app->getIdentity()->authorise('core.create', 'com_content.category.' . $categoryId);
        }

        // In the absence of better information, revert to the component permissions.
        return parent::allowAdd();
    }

    /**
     * Method override to check if you can edit an existing record.
     *
     * @param   array   $data  An array of input data.
     * @param   string  $key   The name of the key for the primary key.
     *
     * @return  boolean
     *
     * @since   1.6
     */
    protected function allowEdit($data = array(), $key = 'id')
    {
        $recordId = (int) isset($data[$key]) ? $data[$key] : 0;
        $user = $this->app->getIdentity();

        // Zero record (id:0), return component edit permission by calling parent controller method
        if (!$recordId) {
            return parent::allowEdit($data, $key);
        }

        // Check edit on the record asset (explicit or inherited)
        if ($user->authorise('core.edit', 'com_content.article.' . $recordId)) {
            return true;
        }

        // Check edit own on the record asset (explicit or inherited)
        if ($user->authorise('core.edit.own', 'com_content.article.' . $recordId)) {
            // Existing record already has an owner, get it
            $record = $this->getModel()->getItem($recordId);

            if (empty($record)) {
                return false;
            }

            // Grant if current user is owner of the record
            return $user->id == $record->created_by;
        }

        return false;
    }

}
